/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.customscalars;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GraphQLScalarTypeDateTime {
    public static GraphQLScalarType DateTime = GraphQLScalarType.newScalar().name("DateTime").description("Custom Scalar for DateTime management. It serializes datetimes in String, formatted as: yyyy-MM-dd'T'HH:mm:ss'Z'").coercing((Coercing)new Coercing<Date, String>(){
        static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String serialize(Object input) throws CoercingSerializeException {
            if (!(input instanceof Date)) {
                throw new CoercingSerializeException("Can't parse the '" + input.toString() + "' string to a DateTime");
            }
            SimpleDateFormat simpleDateFormat = this.formater;
            synchronized (simpleDateFormat) {
                return this.formater.format((Date)input);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date parseValue(Object o) throws CoercingParseValueException {
            if (!(o instanceof String)) {
                throw new CoercingParseValueException("Can't parse the '" + o.toString() + "' string to a DateTime");
            }
            try {
                SimpleDateFormat simpleDateFormat = this.formater;
                synchronized (simpleDateFormat) {
                    return this.formater.parse((String)o);
                }
            }
            catch (ParseException e) {
                throw new CoercingParseValueException(e.getMessage(), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date parseLiteral(Object o) throws CoercingParseLiteralException {
            if (!(o instanceof StringValue)) {
                throw new CoercingParseValueException("Can't parse the '" + o.toString() + "' string to a DateTime");
            }
            try {
                SimpleDateFormat simpleDateFormat = this.formater;
                synchronized (simpleDateFormat) {
                    return this.formater.parse(((StringValue)o).getValue());
                }
            }
            catch (ParseException e) {
                throw new CoercingParseValueException(e.getMessage(), (Throwable)e);
            }
        }
    }).build();
}

