/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.GraphQLError;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class ExecutionContext {
    private final GraphQLSchema graphQLSchema;
    private final ExecutionId executionId;
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private final OperationDefinition operationDefinition;
    private final Map<String, Object> variables;
    private final Object root;
    private final List<GraphQLError> errors = new CopyOnWriteArrayList<GraphQLError>();
    private final Instrumentation instrumentation;

    public ExecutionContext(Instrumentation instrumentation, ExecutionId executionId, GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy, Map<String, FragmentDefinition> fragmentsByName, OperationDefinition operationDefinition, Map<String, Object> variables, Object root) {
        this.graphQLSchema = graphQLSchema;
        this.executionId = executionId;
        this.queryStrategy = queryStrategy;
        this.mutationStrategy = mutationStrategy;
        this.subscriptionStrategy = subscriptionStrategy;
        this.fragmentsByName = fragmentsByName;
        this.operationDefinition = operationDefinition;
        this.variables = variables;
        this.root = root;
        this.instrumentation = instrumentation;
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    public Map<String, FragmentDefinition> getFragmentsByName() {
        return this.fragmentsByName;
    }

    public OperationDefinition getOperationDefinition() {
        return this.operationDefinition;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public <T> T getRoot() {
        return (T)this.root;
    }

    public FragmentDefinition getFragment(String name) {
        return this.fragmentsByName.get(name);
    }

    public void addError(GraphQLError error) {
        this.errors.add(error);
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public ExecutionStrategy getQueryStrategy() {
        return this.queryStrategy;
    }

    public ExecutionStrategy getMutationStrategy() {
        return this.mutationStrategy;
    }

    public ExecutionStrategy getSubscriptionStrategy() {
        return this.subscriptionStrategy;
    }
}

