/*
 * Decompiled with CFR 0.152.
 */
package com.gravityrd.recengclient.webshop;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gravityrd.receng.web.webshop.jsondto.GravityEvent;
import com.gravityrd.receng.web.webshop.jsondto.GravityItem;
import com.gravityrd.receng.web.webshop.jsondto.GravityItemRecommendation;
import com.gravityrd.receng.web.webshop.jsondto.GravityRecEngException;
import com.gravityrd.receng.web.webshop.jsondto.GravityRecommendationContext;
import com.gravityrd.receng.web.webshop.jsondto.GravityUser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class GravityClient {
    private String remoteUrl;
    private int readTimeout = 3000;
    private String userName;
    private String password;
    private final String VERSION = "1.0.4";
    private static final ObjectMapper mapper = new ObjectMapper();

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void addEvents(GravityEvent[] events, boolean async) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        queryStringParams.put("async", Boolean.toString(async));
        this.sendRequest("addEvents", queryStringParams, events, false, null);
    }

    public void addUsers(GravityUser[] users, boolean async) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        queryStringParams.put("async", Boolean.toString(async));
        this.sendRequest("addUsers", queryStringParams, users, false, null);
    }

    public void addItems(GravityItem[] items, boolean async) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        queryStringParams.put("async", Boolean.toString(async));
        this.sendRequest("addItems", queryStringParams, items, false, null);
    }

    public GravityItemRecommendation getItemRecommendation(String userId, String cookieId, GravityRecommendationContext context) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        if (userId != null) {
            queryStringParams.put("userId", userId);
        }
        if (cookieId != null) {
            queryStringParams.put("cookieId", cookieId);
        }
        return (GravityItemRecommendation)this.sendRequest("getItemRecommendation", queryStringParams, context, true, GravityItemRecommendation.class);
    }

    public GravityItemRecommendation[] getItemRecommendationBulk(String userId, String cookieId, GravityRecommendationContext[] context) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        if (userId != null) {
            queryStringParams.put("userId", userId);
        }
        if (cookieId != null) {
            queryStringParams.put("cookieId", cookieId);
        }
        return (GravityItemRecommendation[])this.sendRequest("getItemRecommendationBulk", queryStringParams, context, true, GravityItemRecommendation[].class);
    }

    public String test(String name) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        queryStringParams.put("name", name);
        return (String)this.sendRequest("test", queryStringParams, name, true, String.class);
    }

    public void testException() throws GravityRecEngException, IOException {
        this.sendRequest("testException", null, null, true, null);
    }

    private String getRequestQueryString(String methodName, Map<String, String> queryStringParams) throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        if (queryStringParams != null) {
            for (Map.Entry<String, String> pair : queryStringParams.entrySet()) {
                queryString.append(URLEncoder.encode(pair.getKey(), "UTF-8")).append("=");
                queryString.append(URLEncoder.encode(pair.getValue(), "UTF-8")).append("&");
            }
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
            queryString.insert(0, "&");
        }
        return "?method=" + URLEncoder.encode(methodName, "UTF-8") + queryString.toString();
    }

    private Object sendRequest(String methodName, Map<String, String> queryStringParams, Object requestBody, boolean hasAnswer, Class answerClass) throws GravityRecEngException, IOException {
        URL myUrl = new URL(this.remoteUrl + "/" + methodName + this.getRequestQueryString(methodName, queryStringParams));
        HttpURLConnection connection = (HttpURLConnection)myUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.addRequestProperty("X-Gravity-RecEng-JavaClient-Webshop-Version", "1.0.4");
        connection.setReadTimeout(this.readTimeout);
        connection.setConnectTimeout(this.readTimeout);
        connection.setDoOutput(true);
        Authenticator.setDefault(new UserPasswordAuthenticator(this.userName, this.password));
        String json = mapper.writeValueAsString(requestBody);
        OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
        wr.write(json);
        wr.close();
        if (connection.getResponseCode() == 500) {
            throw (GravityRecEngException)mapper.readValue(this.getBodyAsString(connection.getErrorStream()), GravityRecEngException.class);
        }
        connection.getInputStream();
        if (hasAnswer) {
            return mapper.readValue(this.getBodyAsString(connection.getInputStream()), answerClass);
        }
        return null;
    }

    private String getBodyAsString(InputStream input) throws IOException {
        int readChars;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[2048];
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));
        while ((readChars = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, readChars);
        }
        return sb.toString();
    }

    private static class UserPasswordAuthenticator
    extends Authenticator {
        private final String username;
        private final String password;

        public UserPasswordAuthenticator(String user, String pwd) {
            this.username = user;
            this.password = pwd;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }
}

