/*
 * Decompiled with CFR 0.152.
 */
package com.gravityrd.recengclient.webshop;

import com.gravityrd.receng.web.webshop.jsondto.GravityNameValue;
import com.gravityrd.receng.web.webshop.jsondto.GravityRecommendationContext;
import com.gravityrd.receng.web.webshop.jsondto.facet.DynamicRangeFacetRequest;
import com.gravityrd.receng.web.webshop.jsondto.facet.FacetRequest;
import com.gravityrd.receng.web.webshop.jsondto.facet.Range;
import com.gravityrd.receng.web.webshop.jsondto.facet.RangeFacetRequest;
import com.gravityrd.receng.web.webshop.jsondto.facet.TermFacetRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GravityRecommendationContextBuilder {
    private int recommendationTime = (int)(System.currentTimeMillis() / 1000L);
    private int numberLimit;
    private String scenarioId;
    private List<GravityNameValue> nameValues = new ArrayList<GravityNameValue>();
    private Set<String> resultNameValues = new HashSet<String>();
    private HashMap<String, String[]> resultNameValueFilters = new HashMap();
    private List<FacetRequest<?>> facets = new ArrayList();

    public static FacetBuilder.TermFacetBuilder term(String field, int count) {
        return new FacetBuilder.TermFacetBuilder(field, count);
    }

    public static FacetBuilder.RangeFacetBuilder range(String field) {
        return new FacetBuilder.RangeFacetBuilder(field);
    }

    public static FacetBuilder.RangeFacetBuilder range(String field, List<Range> ranges) {
        return new FacetBuilder.RangeFacetBuilder(field, ranges);
    }

    public GravityRecommendationContextBuilder(String scenarioId, int numberLimit) {
        this.numberLimit = numberLimit;
        this.scenarioId = scenarioId;
    }

    public GravityRecommendationContextBuilder setRecommendationTime(int recommendationTime) {
        this.recommendationTime = recommendationTime;
        return this;
    }

    public GravityRecommendationContextBuilder addNameValue(String name, String value) {
        this.nameValues.add(new GravityNameValue(name, value));
        return this;
    }

    public GravityRecommendationContextBuilder addNameValue(List<String> names, List<String> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException("Size of names and values should be equal!");
        }
        for (int i = 0; i < names.size(); ++i) {
            this.nameValues.add(new GravityNameValue(names.get(i), values.get(i)));
        }
        return this;
    }

    public GravityRecommendationContextBuilder addNameValue(Collection<GravityNameValue> nameValues) {
        this.nameValues.addAll(nameValues);
        return this;
    }

    public GravityRecommendationContextBuilder addResultNameValue(String name) {
        this.resultNameValues.add(name);
        return this;
    }

    public GravityRecommendationContextBuilder addResultNameValues(Collection<String> names) {
        this.resultNameValues.addAll(names);
        return this;
    }

    public GravityRecommendationContextBuilder addResultNameValueFilter(String name, Collection<String> values) {
        this.resultNameValueFilters.put(name, values.toArray(new String[values.size()]));
        return this;
    }

    public GravityRecommendationContextBuilder addFacet(FacetRequest<?> facet) {
        this.facets.add(facet);
        return this;
    }

    public GravityRecommendationContextBuilder addFacet(FacetBuilder.FacetRequestBuilder<?, ?, ?> facetBuilder) {
        this.facets.add((FacetRequest<?>)facetBuilder.build());
        return this;
    }

    public GravityRecommendationContext build() {
        GravityRecommendationContext context = new GravityRecommendationContext();
        context.scenarioId = this.scenarioId;
        context.numberLimit = this.numberLimit;
        context.recommendationTime = this.recommendationTime;
        context.nameValues = this.nameValues.toArray(new GravityNameValue[this.nameValues.size()]);
        context.resultNameValues = this.resultNameValues.toArray(new String[this.resultNameValues.size()]);
        context.resultNameValueFilters = this.resultNameValueFilters.size() > 0 ? this.resultNameValueFilters : null;
        context.facets = this.facets.size() > 0 ? this.facets : null;
        return context;
    }

    public static final class DynamicRangeFacetBuilder
    extends FacetBuilder.FacetRequestBuilder<DynamicRangeFacetBuilder, DynamicRangeFacetRequest, Range> {
        private List<Range> ranges = new ArrayList<Range>();
        private int maxRangeCount;
        private int quantum;

        public DynamicRangeFacetBuilder(String field, int maxRangeCount, int quantum) {
            super(field);
            this.maxRangeCount = maxRangeCount;
            this.quantum = quantum;
        }

        public DynamicRangeFacetBuilder filterValue(Double from, Double to) {
            this.filterValues.add(new Range(from, to));
            return this;
        }

        @Override
        public DynamicRangeFacetRequest build() {
            FacetRequest.Filter filter = null;
            if (this.filterValues.size() > 0) {
                filter = new FacetRequest.Filter(this.filterLogic, this.filterValues);
            }
            return new DynamicRangeFacetRequest(this.field, this.maxRangeCount, this.quantum, filter);
        }
    }

    public static final class FacetBuilder {
        public static TermFacetBuilder term(String field, int count) {
            return new TermFacetBuilder(field, count);
        }

        public static RangeFacetBuilder range(String field) {
            return new RangeFacetBuilder(field);
        }

        public static RangeFacetBuilder range(String field, List<Range> ranges) {
            return new RangeFacetBuilder(field, ranges);
        }

        public static DynamicRangeFacetBuilder dynamicRange(String field, int maxRangeCount, int quantum) {
            return new DynamicRangeFacetBuilder(field, maxRangeCount, quantum);
        }

        public static final class RangeFacetBuilder
        extends FacetRequestBuilder<RangeFacetBuilder, RangeFacetRequest, Range> {
            private List<Range> ranges = new ArrayList<Range>();

            public RangeFacetBuilder(String field) {
                super(field);
            }

            public RangeFacetBuilder(String field, Collection<Range> ranges) {
                super(field);
                this.ranges.addAll(ranges);
            }

            public RangeFacetBuilder addRange(Range range) {
                this.ranges.add(range);
                return this;
            }

            public RangeFacetBuilder addRanges(Collection<Range> ranges) {
                this.ranges.addAll(ranges);
                return this;
            }

            public RangeFacetBuilder addRange(Double from, Double to) {
                this.ranges.add(new Range(from, to));
                return this;
            }

            public RangeFacetBuilder filterValue(Double from, Double to) {
                this.filterValues.add(new Range(from, to));
                return this;
            }

            @Override
            public RangeFacetRequest build() {
                if (this.ranges.size() == 0) {
                    throw new IllegalStateException("At least one range should be specified");
                }
                FacetRequest.Filter filter = null;
                if (this.filterValues.size() > 0) {
                    filter = new FacetRequest.Filter(this.filterLogic, this.filterValues);
                }
                return new RangeFacetRequest(this.field, this.ranges, filter);
            }
        }

        public static final class TermFacetBuilder
        extends FacetRequestBuilder<TermFacetBuilder, TermFacetRequest, String> {
            private int count;
            private TermFacetRequest.Order order;

            public TermFacetBuilder(String field, int count) {
                super(field);
                this.count = count;
            }

            public TermFacetBuilder order(TermFacetRequest.Order order) {
                this.order = order;
                return this;
            }

            @Override
            public TermFacetRequest build() {
                FacetRequest.Filter filter = null;
                if (this.filterValues.size() > 0) {
                    filter = new FacetRequest.Filter(this.filterLogic, this.filterValues);
                }
                return new TermFacetRequest(this.field, this.count, this.order, filter);
            }
        }

        public static abstract class FacetRequestBuilder<B extends FacetRequestBuilder<B, T, F>, T extends FacetRequest<F>, F> {
            protected String field;
            protected FacetRequest.FilterLogic filterLogic;
            protected List<F> filterValues = new ArrayList<F>();

            abstract T build();

            public FacetRequestBuilder(String field) {
                this.field = field;
            }

            public B filterLogic(FacetRequest.FilterLogic filterLogic) {
                this.filterLogic = filterLogic;
                return (B)this;
            }

            public B filterValue(F value) {
                this.filterValues.add(value);
                return (B)this;
            }

            public B filterValues(Collection<F> values) {
                this.filterValues.addAll(values);
                return (B)this;
            }
        }
    }
}

