/*
 * Decompiled with CFR 0.152.
 */
package com.gravityrd.recengclient.webshop;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gravityrd.receng.web.webshop.jsondto.GravityEvent;
import com.gravityrd.receng.web.webshop.jsondto.GravityItem;
import com.gravityrd.receng.web.webshop.jsondto.GravityItemRecommendation;
import com.gravityrd.receng.web.webshop.jsondto.GravityRecEngException;
import com.gravityrd.receng.web.webshop.jsondto.GravityRecommendationContext;
import com.gravityrd.receng.web.webshop.jsondto.GravityScenario;
import com.gravityrd.receng.web.webshop.jsondto.GravityUser;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public final class GravityClient {
    protected static final ObjectMapper mapper = new ObjectMapper();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final String VERSION = "1.4.0";
    private String remoteUrl;
    private int readTimeout = 3000;
    private String userName;
    private String password;

    public GravityScenario[] getScenarioInformation() throws GravityRecEngException, IOException {
        return (GravityScenario[])this.sendRequest("scenarioInfo", null, null, true, GravityScenario[].class);
    }

    private Object sendRequest(String methodName, Map<String, String> queryStringParams, Object requestBody, boolean hasAnswer, Class answerClass) throws GravityRecEngException, IOException {
        HttpURLConnection connection = this.sendRequest(methodName, queryStringParams, requestBody);
        if (connection.getResponseCode() / 100 != 2) {
            this.handleError(requestBody, connection);
        }
        if (hasAnswer) {
            Throwable throwable = null;
            try (InputStream inputStream = connection.getInputStream();){
                String bodyString = this.getBodyAsString(inputStream);
                try {
                    Object object = mapper.readValue(bodyString, answerClass);
                    return object;
                }
                catch (Exception e) {
                    try {
                        throw new GravityRecEngException(e.getMessage(), "");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        return null;
    }

    private HttpURLConnection sendRequest(String methodName, Map<String, String> queryStringParams, Object requestBody) throws IOException {
        HttpURLConnection connection = this.createConnection(methodName, queryStringParams);
        this.setRequestHeaders(connection);
        if (this.userName == null) {
            throw new IllegalStateException("set the user name");
        }
        if (this.password == null) {
            throw new IllegalStateException("set the password");
        }
        String userPassword = this.userName + ":" + this.password;
        connection.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])userPassword.getBytes(UTF8)), UTF8));
        this.sendPostRequest(requestBody, connection);
        return connection;
    }

    private void handleError(Object requestBody, HttpURLConnection connection) throws IOException, GravityRecEngException {
        String responseBody = this.getBodyAsString(connection.getErrorStream());
        String b = requestBody == null ? "" : (requestBody.getClass().isArray() ? Arrays.toString((Object[])requestBody) : requestBody.toString());
        String message = String.format("response code %d, for url %s | request content '%s' | answer '%s'", connection.getResponseCode(), connection.getURL(), b, responseBody);
        if (responseBody == null) {
            throw new GravityRecEngException(message, "");
        }
        try {
            GravityRecEngException exception = (GravityRecEngException)((Object)mapper.readValue(responseBody, GravityRecEngException.class));
            throw exception;
        }
        catch (GravityRecEngException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GravityRecEngException(message + " body " + responseBody, "");
        }
    }

    private String getBodyAsString(InputStream input) throws IOException {
        int readChars;
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[2048];
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));
        while ((readChars = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, readChars);
        }
        return sb.toString();
    }

    private HttpURLConnection createConnection(String methodName, Map<String, String> queryStringParams) throws IOException {
        if (this.remoteUrl == null) {
            throw new IllegalStateException("set the remote URL");
        }
        String urlString = this.remoteUrl + "/" + methodName + this.getRequestQueryString(methodName, queryStringParams);
        URL url = new URL(urlString);
        return (HttpURLConnection)url.openConnection();
    }

    private void setRequestHeaders(HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("POST");
        connection.addRequestProperty("User-Agent", "Gravity-RecEng-JavaClient-Webshop");
        connection.addRequestProperty("X-Gravity-RecEng-JavaClient-Webshop-Version", "1.4.0");
        connection.setReadTimeout(this.readTimeout);
        connection.setConnectTimeout(this.readTimeout);
        connection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
    }

    private void sendPostRequest(Object requestBody, HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();
             DataOutputStream wr = new DataOutputStream(outputStream);){
            String requestJson = mapper.writeValueAsString(requestBody);
            wr.writeBytes(requestJson);
            wr.flush();
        }
    }

    private String getRequestQueryString(String methodName, Map<String, String> queryStringParams) throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        if (queryStringParams != null) {
            for (Map.Entry<String, String> pair : queryStringParams.entrySet()) {
                queryString.append(URLEncoder.encode(pair.getKey(), "UTF-8")).append("=");
                queryString.append(URLEncoder.encode(pair.getValue(), "UTF-8")).append("&");
            }
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
            queryString.insert(0, "&");
        }
        return "?method=" + URLEncoder.encode(methodName, "UTF-8") + queryString.toString();
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void addEvents(GravityEvent[] events, boolean async) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        queryStringParams.put("async", Boolean.toString(async));
        this.sendRequest("addEvents", queryStringParams, events, false, null);
    }

    public void addUsers(GravityUser[] users, boolean async) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        queryStringParams.put("async", Boolean.toString(async));
        this.sendRequest("addUsers", queryStringParams, users, false, null);
    }

    public GravityUser getUserByUserId(String userId) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>(1);
        queryStringParams.put("userId", userId);
        return (GravityUser)this.sendRequest("getUser", queryStringParams, null, true, GravityUser.class);
    }

    public GravityUser getUserByCookieId(String cookieId) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>(1);
        queryStringParams.put("cookieId", cookieId);
        return (GravityUser)this.sendRequest("getUser", queryStringParams, null, true, GravityUser.class);
    }

    public GravityEvent[] getEventsByUserId(String userId, int limit) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>(1);
        queryStringParams.put("userId", userId);
        if (limit > 0) {
            queryStringParams.put("limit", String.valueOf(limit));
        }
        return (GravityEvent[])this.sendRequest("getEvents", queryStringParams, null, true, GravityEvent[].class);
    }

    public GravityEvent[] getEventsByCookieId(String cookieId, int limit) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>(1);
        queryStringParams.put("cookieId", cookieId);
        if (limit > 0) {
            queryStringParams.put("limit", String.valueOf(limit));
        }
        return (GravityEvent[])this.sendRequest("getEvents", queryStringParams, null, true, GravityEvent[].class);
    }

    public void optOutUser(String userId) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>(1);
        queryStringParams.put("userId", userId);
        this.sendRequest("optOut", queryStringParams, null, false, null);
    }

    public void optOutCookie(String cookieId) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>(1);
        queryStringParams.put("cookieId", cookieId);
        this.sendRequest("optOut", queryStringParams, null, false, null);
    }

    public void addItems(GravityItem[] items, boolean async) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        queryStringParams.put("async", Boolean.toString(async));
        this.sendRequest("addItems", queryStringParams, items, false, null);
    }

    public GravityItemRecommendation getItemRecommendation(String userId, String cookieId, GravityRecommendationContext context) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        if (userId != null) {
            queryStringParams.put("userId", userId);
        }
        if (cookieId != null) {
            queryStringParams.put("cookieId", cookieId);
        }
        return (GravityItemRecommendation)this.sendRequest("getItemRecommendation", queryStringParams, context, true, GravityItemRecommendation.class);
    }

    public GravityItemRecommendation[] getItemRecommendationBulk(String userId, String cookieId, GravityRecommendationContext[] context) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        if (userId != null) {
            queryStringParams.put("userId", userId);
        }
        if (cookieId != null) {
            queryStringParams.put("cookieId", cookieId);
        }
        return (GravityItemRecommendation[])this.sendRequest("getItemRecommendationBulk", queryStringParams, context, true, GravityItemRecommendation[].class);
    }

    public String test(String name) throws GravityRecEngException, IOException {
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        queryStringParams.put("name", name);
        return (String)this.sendRequest("test", queryStringParams, name, true, String.class);
    }

    public void testException() throws GravityRecEngException, IOException {
        this.sendRequest("testException", null, null, true, null);
    }

    static {
        mapper.getFactory().configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        mapper.getFactory().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
    }
}

