/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver;

import com.kttdevelopment.simplehttpserver.HttpSession;
import com.kttdevelopment.simplehttpserver.SimpleHttpCookie;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class HttpSessionHandler {
    private final Map<String, HttpSession> sessions = Collections.synchronizedMap(new HashMap());
    private final String cookie;

    public HttpSessionHandler() {
        this.cookie = "__session-id";
    }

    public HttpSessionHandler(String cookie) {
        this.cookie = cookie;
    }

    public synchronized String assignSessionID(HttpExchange exchange) {
        String id;
        while (this.sessions.containsKey(id = UUID.randomUUID().toString())) {
        }
        return id;
    }

    private String getSetSession(Headers headers) {
        if (headers.containsKey("Set-Cookie")) {
            Iterator iterator = headers.get("Set-Cookie").iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                if (!value.startsWith(this.cookie + "=")) continue;
                return value.substring(this.cookie.length() + 1, value.indexOf(";"));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpSession getSession(final HttpExchange exchange) {
        HttpSession session;
        String setSession;
        String rcookies = exchange.getRequestHeaders().getFirst("Cookie");
        HashMap<String, String> cookies = new HashMap<String, String>();
        if (rcookies != null && !rcookies.isEmpty()) {
            String[] pairs;
            for (String pair : pairs = rcookies.split("; ")) {
                String[] value = pair.split("=");
                cookies.put(value[0], value[1]);
            }
        }
        String sessionId = (setSession = this.getSetSession(exchange.getResponseHeaders())) != null ? setSession : (String)cookies.get(this.cookie);
        HttpSessionHandler httpSessionHandler = this;
        synchronized (httpSessionHandler) {
            if (!this.sessions.containsKey(sessionId)) {
                session = new HttpSession(){
                    private final String sessionID;
                    private final long creationTime;
                    private long lastAccessTime;
                    {
                        this.sessionID = HttpSessionHandler.this.assignSessionID(exchange);
                        this.lastAccessTime = this.creationTime = System.currentTimeMillis();
                        sessions.put(this.sessionID, this);
                    }

                    @Override
                    public final String getSessionID() {
                        return this.sessionID;
                    }

                    @Override
                    public final long getCreationTime() {
                        return this.creationTime;
                    }

                    @Override
                    public final long getLastAccessTime() {
                        return this.lastAccessTime;
                    }

                    @Override
                    public final synchronized void updateLastAccessTime() {
                        this.lastAccessTime = System.currentTimeMillis();
                    }

                    public String toString() {
                        return "HttpSession{sessionID=" + this.sessionID + ", creationTime=" + this.creationTime + ", lastAccessTime=" + this.lastAccessTime + "}";
                    }
                };
                SimpleHttpCookie out = new SimpleHttpCookie.Builder(this.cookie, session.getSessionID()).setPath("/").setHttpOnly(true).build();
                exchange.getResponseHeaders().add("Set-Cookie", out.toCookieHeaderString());
                this.sessions.put(session.getSessionID(), session);
            } else {
                session = this.sessions.get(sessionId);
            }
        }
        return session;
    }

    public String toString() {
        return "HttpSessionHandler{sessions=" + this.sessions + ", cookie=" + this.cookie + ", }";
    }
}

