/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.handler.ByteLoadingOption;
import com.kttdevelopment.simplehttpserver.handler.FileBytesAdapter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;

class FileEntry {
    private final File file;
    private final FileBytesAdapter adapter;
    private final ByteLoadingOption loadingOption;
    private byte[] preloadedBytes;

    FileEntry(File file, FileBytesAdapter bytesAdapter, ByteLoadingOption loadingOption) {
        this(file, bytesAdapter, loadingOption, false);
    }

    FileEntry(File file, FileBytesAdapter adapter, ByteLoadingOption loadingOption, boolean skipWatchService) {
        this.file = file;
        this.loadingOption = loadingOption;
        this.adapter = adapter;
        switch (loadingOption) {
            case WATCHLOAD: {
                if (!skipWatchService) {
                    try {
                        WatchService service = FileSystems.getDefault().newWatchService();
                        Path target = file.toPath();
                        Path path = file.getParentFile().toPath();
                        path.register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                        new Thread(() -> {
                            try {
                                WatchKey key;
                                while ((key = service.take()) != null) {
                                    for (WatchEvent<?> event : key.pollEvents()) {
                                        try {
                                            Path modified = path.resolve((Path)event.context());
                                            try {
                                                if (modified.toFile().isDirectory() || !Files.isSameFile(target, modified)) continue;
                                                this.preloadedBytes = adapter.getBytes(file, Files.readAllBytes(target));
                                            }
                                            catch (IOException iOException) {
                                            }
                                        }
                                        catch (ClassCastException classCastException) {}
                                    }
                                    key.reset();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }).start();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            case PRELOAD: {
                try {
                    this.preloadedBytes = adapter.getBytes(file, Files.readAllBytes(file.toPath()));
                    break;
                }
                catch (Exception ignored) {
                    this.preloadedBytes = null;
                }
            }
        }
    }

    public final File getFile() {
        return this.file;
    }

    public final void reloadBytes() {
        if (this.loadingOption != ByteLoadingOption.LIVELOAD) {
            try {
                this.preloadedBytes = this.adapter.getBytes(this.file, Files.readAllBytes(this.file.toPath()));
            }
            catch (IOException e) {
                this.preloadedBytes = null;
            }
        }
    }

    public final byte[] getBytes() {
        if (this.loadingOption != ByteLoadingOption.LIVELOAD) {
            return this.preloadedBytes;
        }
        try {
            return this.adapter.getBytes(this.file, Files.readAllBytes(this.file.toPath()));
        }
        catch (IOException e) {
            return null;
        }
    }

    public final ByteLoadingOption getLoadingOption() {
        return this.loadingOption;
    }

    public String toString() {
        return "FileEntry{file=" + this.file + ", adapter=" + this.adapter + ", loadingOption=" + this.loadingOption + ", preloadedBytes=" + Arrays.toString(this.preloadedBytes) + "}";
    }
}

