/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver;

import com.kttdevelopment.simplehttpserver.FileRecord;
import com.kttdevelopment.simplehttpserver.MultipartFormData;
import com.kttdevelopment.simplehttpserver.Record;
import com.kttdevelopment.simplehttpserver.SimpleHttpCookie;
import com.kttdevelopment.simplehttpserver.SimpleHttpExchange;
import com.kttdevelopment.simplehttpserver.var.RequestMethod;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

final class SimpleHttpExchangeImpl
extends SimpleHttpExchange {
    private final HttpServer httpServer;
    private final HttpExchange httpExchange;
    private final URI URI;
    private final InetSocketAddress publicAddr;
    private final InetSocketAddress localAddr;
    private final HttpContext httpContext;
    private final HttpPrincipal httpPrincipal;
    private final String protocol;
    private final Headers requestHeaders;
    private final RequestMethod requestMethod;
    private final String rawGet;
    private final Map<String, String> getMap;
    private final boolean hasGet;
    private final String rawPost;
    private final Map postMap;
    private final MultipartFormData multipartFormData;
    private final boolean hasPost;
    private final Map<String, String> cookies;
    private final OutputStream outputStream;
    private final Function<String, Map<String, String>> parseWwwFormEnc = s -> {
        String[] pairs;
        LinkedHashMap<String, String> OUT = new LinkedHashMap<String, String>();
        for (String pair : pairs = s.split("&")) {
            if (!pair.contains("=")) continue;
            String[] kv = pair.split("=");
            OUT.put(URLDecoder.decode(kv[0], StandardCharsets.UTF_8), kv.length == 2 ? URLDecoder.decode(kv[1], StandardCharsets.UTF_8) : null);
        }
        return OUT;
    };

    static SimpleHttpExchange create(HttpExchange exchange) {
        return new SimpleHttpExchangeImpl(exchange);
    }

    /*
     * WARNING - void declaration
     */
    SimpleHttpExchangeImpl(HttpExchange exchange) {
        String OUT;
        this.httpContext = exchange.getHttpContext();
        this.httpServer = this.httpContext.getServer();
        this.httpExchange = exchange;
        this.URI = this.httpExchange.getRequestURI();
        this.publicAddr = this.httpExchange.getRemoteAddress();
        this.localAddr = this.httpExchange.getLocalAddress();
        this.httpPrincipal = this.httpExchange.getPrincipal();
        this.protocol = this.httpExchange.getProtocol();
        this.requestHeaders = this.httpExchange.getRequestHeaders();
        switch (exchange.getRequestMethod()) {
            case "GET": {
                this.requestMethod = RequestMethod.GET;
                break;
            }
            case "HEAD": {
                this.requestMethod = RequestMethod.HEAD;
                break;
            }
            case "POST": {
                this.requestMethod = RequestMethod.POST;
                break;
            }
            case "PUT": {
                this.requestMethod = RequestMethod.PUT;
                break;
            }
            case "DELETE": {
                this.requestMethod = RequestMethod.DELETE;
                break;
            }
            case "CONNECT": {
                this.requestMethod = RequestMethod.CONNECT;
                break;
            }
            case "OPTIONS": {
                this.requestMethod = RequestMethod.OPTIONS;
                break;
            }
            case "TRACE": {
                this.requestMethod = RequestMethod.TRACE;
                break;
            }
            case "PATCH": {
                this.requestMethod = RequestMethod.PATCH;
                break;
            }
            default: {
                this.requestMethod = RequestMethod.UNSUPPORTED;
            }
        }
        this.rawGet = this.URI.getRawQuery();
        this.hasGet = this.rawGet != null;
        this.getMap = this.hasGet ? Collections.unmodifiableMap(this.parseWwwFormEnc.apply(this.rawGet)) : new HashMap<String, String>();
        try (InputStream IN = this.httpExchange.getRequestBody();
             Scanner scanner = new Scanner(IN, StandardCharsets.UTF_8);){
            OUT = scanner.useDelimiter("\\A").next();
        }
        catch (IOException | NoSuchElementException ignored) {
            OUT = null;
        }
        this.rawPost = OUT;
        boolean bl = this.hasPost = this.rawPost != null;
        if (this.hasPost) {
            String content_type = this.requestHeaders.getFirst("Content-type");
            if (content_type != null && content_type.startsWith("multipart/form-data")) {
                void var13_23;
                String[] pairs;
                Pattern boundaryHeaderPattern = Pattern.compile("(.*): (.*?)(?:$|; )(.*)");
                Pattern contentDispositionKVPPattern = Pattern.compile("(.*?)=\"(.*?)\"(?:; |$)");
                String webkitBoundary = content_type.substring(content_type.indexOf("; boundary=") + 11);
                String startBoundary = "--" + webkitBoundary + "\r\n";
                String endBoundary = "--" + webkitBoundary + "--\r\n";
                HashMap postMap_buffer = new HashMap();
                String[] stringArray = pairs = OUT.replace(endBoundary, "").split(Pattern.quote(startBoundary));
                int n = stringArray.length;
                boolean bl2 = false;
                while (var13_23 < n) {
                    String pair = stringArray[var13_23];
                    HashMap postHeaders = new HashMap();
                    if (pair.contains("\r\n\r\n")) {
                        String[] headers;
                        for (String header : headers = pair.substring(0, pair.indexOf("\r\n\r\n")).split("\r\n")) {
                            HashMap<String, Object> headerMap = new HashMap<String, Object>();
                            HashMap<String, String> val = new HashMap<String, String>();
                            Matcher headerMatcher = boundaryHeaderPattern.matcher(header);
                            if (headerMatcher.find()) {
                                Matcher contentDispositionKVPMatcher = contentDispositionKVPPattern.matcher(headerMatcher.group(3));
                                while (contentDispositionKVPMatcher.find()) {
                                    val.put(contentDispositionKVPMatcher.group(1), contentDispositionKVPMatcher.group(2));
                                }
                                headerMap.put("header-name", headerMatcher.group(1));
                                headerMap.put("header-value", headerMatcher.group(2));
                                headerMap.put("parameters", val);
                            }
                            postHeaders.put((String)headerMap.get("header-name"), headerMap);
                        }
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        row.put("headers", postHeaders);
                        row.put("value", pair.substring(pair.indexOf("\r\n\r\n") + 4, pair.lastIndexOf("\r\n")));
                        postMap_buffer.put(((Map)((Map)postHeaders.get("Content-Disposition")).get("parameters")).get("name"), row);
                    }
                    ++var13_23;
                }
                HashMap<String, Record> form_buffer = new HashMap<String, Record>();
                for (Map.Entry<String, Map> entry : postMap_buffer.entrySet()) {
                    try {
                        form_buffer.put((String)entry.getKey(), new FileRecord(entry));
                    }
                    catch (NullPointerException ignored) {
                        try {
                            form_buffer.put((String)entry.getKey(), new Record(entry));
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    catch (ClassCastException ignored) {
                        form_buffer = Collections.emptyMap();
                        break;
                    }
                }
                this.postMap = Collections.unmodifiableMap(postMap_buffer);
                this.multipartFormData = form_buffer.isEmpty() ? null : new MultipartFormData(form_buffer);
            } else {
                this.postMap = Collections.unmodifiableMap(this.parseWwwFormEnc.apply(this.rawPost));
                this.multipartFormData = null;
            }
        } else {
            this.postMap = Collections.emptyMap();
            this.multipartFormData = null;
        }
        String rawCookie = this.requestHeaders.getFirst("Cookie");
        HashMap<String, String> cookie_buffer = new HashMap<String, String>();
        if (rawCookie != null && !rawCookie.isEmpty()) {
            String[] cookedCookie;
            for (String pair : cookedCookie = rawCookie.split("; ")) {
                String[] value = pair.split("=");
                cookie_buffer.put(value[0], value[1]);
            }
        }
        this.cookies = Collections.unmodifiableMap(cookie_buffer);
        this.outputStream = exchange.getResponseBody();
    }

    @Override
    public final HttpServer getHttpServer() {
        return this.httpServer;
    }

    @Override
    public final HttpExchange getHttpExchange() {
        return this.httpExchange;
    }

    @Override
    public final URI getURI() {
        return this.URI;
    }

    @Override
    public final InetSocketAddress getPublicAddress() {
        return this.publicAddr;
    }

    @Override
    public final InetSocketAddress getLocalAddress() {
        return this.localAddr;
    }

    @Override
    public final HttpContext getHttpContext() {
        return this.httpContext;
    }

    @Override
    public final HttpPrincipal getHttpPrincipal() {
        return this.httpPrincipal;
    }

    @Override
    public final String getProtocol() {
        return this.protocol;
    }

    @Override
    public final Headers getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public final RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public final String getRawGet() {
        return this.rawGet;
    }

    @Override
    public final Map<String, String> getGetMap() {
        return this.getMap;
    }

    @Override
    public final boolean hasGet() {
        return this.hasGet;
    }

    @Override
    public final String getRawPost() {
        return this.rawPost;
    }

    @Override
    public final Map getPostMap() {
        return this.postMap;
    }

    @Override
    public final MultipartFormData getMultipartFormData() {
        return this.multipartFormData;
    }

    @Override
    public final boolean hasPost() {
        return this.hasPost;
    }

    @Override
    public final Headers getResponseHeaders() {
        return this.httpExchange.getResponseHeaders();
    }

    @Override
    public final int getResponseCode() {
        return this.httpExchange.getResponseCode();
    }

    @Override
    public final Map<String, String> getCookies() {
        return this.cookies;
    }

    @Override
    public final synchronized void setCookie(String key, String value) {
        this.setCookie(new SimpleHttpCookie.Builder(key, value).build());
    }

    @Override
    public final synchronized void setCookie(SimpleHttpCookie cookie) {
        String cstring = cookie.toCookieHeaderString();
        this.getResponseHeaders().add("Set-Cookie", cstring);
    }

    @Override
    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public final synchronized void sendResponseHeaders(int code, long length) throws IOException {
        this.httpExchange.sendResponseHeaders(code, length);
    }

    @Override
    public final synchronized void send(int responseCode) throws IOException {
        this.sendResponseHeaders(responseCode, 0L);
    }

    @Override
    public final synchronized void send(byte[] response) throws IOException {
        this.send(response, 200, false);
    }

    @Override
    public final void send(byte[] response, boolean gzip) throws IOException {
        this.send(response, 200, gzip);
    }

    @Override
    public final synchronized void send(byte[] response, int responseCode) throws IOException {
        this.send(response, responseCode, false);
    }

    @Override
    public final void send(byte[] response, int responseCode, boolean gzip) throws IOException {
        if (gzip) {
            this.httpExchange.getResponseHeaders().set("Accept-Encoding", "gzip");
            this.httpExchange.getResponseHeaders().set("Content-Encoding", "gzip");
            this.httpExchange.getResponseHeaders().set("Connection", "keep-alive");
            this.sendResponseHeaders(responseCode, 0L);
            try (GZIPOutputStream OUT = new GZIPOutputStream(this.httpExchange.getResponseBody());){
                OUT.write(response);
                OUT.finish();
                OUT.flush();
            }
        }
        this.sendResponseHeaders(responseCode, response.length);
        try (OutputStream OUT = this.httpExchange.getResponseBody();){
            OUT.write(response);
            OUT.flush();
        }
    }

    @Override
    public final synchronized void send(String response) throws IOException {
        this.send(response.getBytes(StandardCharsets.UTF_8), 200, false);
    }

    @Override
    public final void send(String response, boolean gzip) throws IOException {
        this.send(response.getBytes(StandardCharsets.UTF_8), 200, gzip);
    }

    @Override
    public final synchronized void send(String response, int responseCode) throws IOException {
        this.send(response.getBytes(StandardCharsets.UTF_8), responseCode, false);
    }

    @Override
    public final void send(String response, int responseCode, boolean gzip) throws IOException {
        this.send(response.getBytes(StandardCharsets.UTF_8), responseCode, gzip);
    }

    @Override
    public final void send(File file) throws IOException {
        this.send(Files.readAllBytes(file.toPath()));
    }

    @Override
    public final void send(File file, boolean gzip) throws IOException {
        this.send(Files.readAllBytes(file.toPath()), true);
    }

    @Override
    public final void send(File file, int responseCode) throws IOException {
        this.send(Files.readAllBytes(file.toPath()), responseCode);
    }

    @Override
    public final void send(File file, int responseCode, boolean gzip) throws IOException {
        this.send(Files.readAllBytes(file.toPath()), responseCode, gzip);
    }

    @Override
    public final synchronized void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.httpExchange.close();
    }

    @Override
    public final Object getAttribute(String name) {
        return this.httpExchange.getAttribute(name);
    }

    @Override
    public final synchronized void setAttribute(String name, Object value) {
        this.httpExchange.setAttribute(name, value);
    }

    public String toString() {
        return "SimpleHttpExchange{httpServer=" + this.httpServer + ", httpExchange=" + this.httpExchange + ", URI=" + this.URI + ", publicAddress=" + this.publicAddr + ", localAddress=" + this.localAddr + ", httpContext=" + this.httpContext + ", httpPrincipal=" + this.httpPrincipal + ", protocol='" + this.protocol + "', requestHeaders=" + this.requestHeaders + ", requestMethod=" + this.requestMethod + ", responseHeaders=" + this.getResponseHeaders() + ", responseCode=" + this.getResponseCode() + ", rawGet='" + this.rawGet + "', getMap=" + this.getMap + ", hasGet=" + this.hasGet + ", rawPost='" + this.rawPost + "', postMap=" + this.postMap + ", hasPost=" + this.hasPost + ", cookies=" + this.cookies + "}";
    }
}

