/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.handler.ConnectionThrottler;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;

public class ThrottledHandler
implements HttpHandler {
    private final HttpHandler handler;
    private final ConnectionThrottler throttler;

    public ThrottledHandler(HttpHandler handler, ConnectionThrottler throttler) {
        this.handler = handler;
        this.throttler = throttler;
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        if (this.throttler.addConnection(exchange)) {
            try {
                this.handler.handle(exchange);
            }
            finally {
                this.throttler.deleteConnection(exchange);
            }
        } else {
            exchange.close();
        }
    }

    public String toString() {
        return "ThrottledHandler{handler=" + this.handler + ", throttler=" + this.throttler + "}";
    }
}

