/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.handler.ByteLoadingOption;
import com.kttdevelopment.simplehttpserver.handler.CacheFileAdapter;
import com.kttdevelopment.simplehttpserver.handler.FileBytesAdapter;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

class FileEntry {
    private final File file;
    private final FileBytesAdapter adapter;
    private final ByteLoadingOption loadingOption;
    private byte[] bytes = null;
    private final AtomicLong lastModified = new AtomicLong();
    private final AtomicLong expiry = new AtomicLong(0L);
    private final long cacheTime;

    FileEntry(File file, FileBytesAdapter bytesAdapter, ByteLoadingOption loadingOption) {
        if (loadingOption == ByteLoadingOption.CACHELOAD && !(bytesAdapter instanceof CacheFileAdapter)) {
            throw new IllegalArgumentException("CacheLoad option must use a cache file adapter");
        }
        this.file = file;
        this.adapter = bytesAdapter;
        this.loadingOption = loadingOption;
        long l = this.cacheTime = bytesAdapter instanceof CacheFileAdapter ? ((CacheFileAdapter)bytesAdapter).getCacheTimeMillis() : -1L;
        if (loadingOption != ByteLoadingOption.LIVELOAD && loadingOption != ByteLoadingOption.CACHELOAD) {
            try {
                this.bytes = this.adapter.getBytes(file, Files.readAllBytes(file.toPath()));
            }
            catch (Throwable ignored) {
                this.bytes = null;
            }
            if (loadingOption != ByteLoadingOption.PRELOAD) {
                this.lastModified.set(file.lastModified());
            }
        }
    }

    public final File getFile() {
        return this.file;
    }

    public final synchronized void reloadBytes() {
        if (this.loadingOption == ByteLoadingOption.PRELOAD || this.loadingOption == ByteLoadingOption.LIVELOAD) {
            throw new UnsupportedOperationException();
        }
        this.lastModified.set(this.file.lastModified());
        try {
            this.bytes = this.adapter.getBytes(this.file, Files.readAllBytes(this.file.toPath()));
        }
        catch (Throwable ignored) {
            this.bytes = null;
        }
    }

    public final synchronized void clearBytes() {
        if (this.loadingOption == ByteLoadingOption.PRELOAD || this.loadingOption == ByteLoadingOption.LIVELOAD) {
            throw new UnsupportedOperationException();
        }
        this.lastModified.set(0L);
        this.bytes = null;
    }

    public final byte[] getBytes() {
        switch (this.loadingOption) {
            case MODLOAD: 
            case CACHELOAD: {
                long now = System.currentTimeMillis();
                if (this.loadingOption == ByteLoadingOption.CACHELOAD && now > this.expiry.getAndUpdate(was -> now + this.cacheTime) || this.file.lastModified() != this.lastModified.get()) {
                    this.reloadBytes();
                }
            }
            case PRELOAD: {
                return this.bytes;
            }
        }
        try {
            return this.adapter.getBytes(this.file, Files.readAllBytes(this.file.toPath()));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public final ByteLoadingOption getLoadingOption() {
        return this.loadingOption;
    }

    final long getExpiry() {
        return this.expiry.get();
    }

    public String toString() {
        return "FileEntry{file=" + this.file + ", adapter=" + this.adapter + ", loadingOption=" + this.loadingOption + ", bytes=" + Arrays.toString(this.bytes) + "}";
    }
}

