/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Email;
import com.labstack.Interceptor;
import com.labstack.Level;
import com.labstack.Log;
import com.labstack.SearchParameters;
import com.labstack.Store;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;

public class Client {
    private OkHttpClient okHttp;
    protected static Moshi moshi = new Moshi.Builder().build();
    protected static JsonAdapter<SearchParameters> paramsJsonAdapter = moshi.adapter(SearchParameters.class);
    protected static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final String API_URL = "https://api.labstack.com";
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public Client(String apiKey) {
        this.okHttp = new OkHttpClient.Builder().addInterceptor((okhttp3.Interceptor)new Interceptor(apiKey)).build();
    }

    public Email Email() {
        Email email = new Email();
        email.okHttp = this.okHttp;
        return email;
    }

    public Log Log() {
        Log log = new Log();
        log.okHttp = this.okHttp;
        log.setLevel(Level.INFO);
        log.setBatchSize(60);
        log.setDispatchInterval(60);
        return log;
    }

    public Store Store() {
        Store store = new Store();
        store.okHttp = this.okHttp;
        return store;
    }
}

