/*
 * Decompiled with CFR 0.152.
 */
package com.libdbm.cel;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Utilities {
    private Utilities() {
    }

    public static int sizeOf(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.length();
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.size();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.size();
        }
        throw new IllegalArgumentException("size() not supported for type: " + value.getClass().getName());
    }

    public static long asInt(Object value) {
        if (value instanceof Long) {
            Long l = (Long)value;
            return l;
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i.longValue();
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return d.longValue();
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            return Long.parseLong(str);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b != false ? 1L : 0L;
        }
        throw new IllegalArgumentException("Cannot convert to int: " + String.valueOf(value));
    }

    public static long asUInt(Object value) {
        long result = Utilities.asInt(value);
        if (result < 0L) {
            throw new IllegalArgumentException("Cannot convert negative value to uint: " + String.valueOf(value));
        }
        return result;
    }

    public static double asDouble(Object value) {
        if (value instanceof Double) {
            Double d = (Double)value;
            return d;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.doubleValue();
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return l.doubleValue();
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i.doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            return Double.parseDouble(str);
        }
        throw new IllegalArgumentException("Cannot convert to double: " + String.valueOf(value));
    }

    public static String asString(Object value) {
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public static boolean asBool(Object value) {
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return l != 0L;
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i != 0;
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return d != 0.0;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.floatValue() != 0.0f;
        }
        if (value instanceof String) {
            String str = (String)value;
            return !str.isEmpty();
        }
        if (value instanceof List) {
            List list = (List)value;
            return !list.isEmpty();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return !map.isEmpty();
        }
        return value != null;
    }

    public static String typeOf(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Boolean) {
            return "bool";
        }
        if (value instanceof Long || value instanceof Integer) {
            return "int";
        }
        if (value instanceof Double || value instanceof Float) {
            return "double";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof List) {
            return "list";
        }
        if (value instanceof Map) {
            return "map";
        }
        return "unknown";
    }

    public static boolean has(Object target, Object field) {
        if (target instanceof Map) {
            Map map = (Map)target;
            if (field instanceof String) {
                String key = (String)field;
                return map.containsKey(key);
            }
        }
        return false;
    }

    public static boolean matches(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        return regex.matcher(text).find();
    }

    public static Instant timestamp(Object value) {
        if (value == null) {
            return Instant.now();
        }
        if (value instanceof String) {
            String str = (String)value;
            return Instant.parse(str);
        }
        if (value instanceof Long) {
            Long millis = (Long)value;
            return Instant.ofEpochMilli(millis);
        }
        if (value instanceof Integer) {
            Integer millis = (Integer)value;
            return Instant.ofEpochMilli(millis.longValue());
        }
        throw new IllegalArgumentException("Invalid timestamp value: " + String.valueOf(value));
    }

    public static Duration duration(String value) {
        String unit;
        Pattern regex = Pattern.compile("^(\\d+)([hms])$");
        Matcher matcher = regex.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid duration format: " + value);
        }
        int amount = Integer.parseInt(matcher.group(1));
        return switch (unit = matcher.group(2)) {
            case "h" -> Duration.ofHours(amount);
            case "m" -> Duration.ofMinutes(amount);
            case "s" -> Duration.ofSeconds(amount);
            default -> throw new IllegalArgumentException("Invalid duration unit: " + unit);
        };
    }

    public static int dateOf(Object value) {
        Instant i;
        Instant instant = value instanceof Instant ? (i = (Instant)value) : Utilities.timestamp(value);
        ZonedDateTime date = instant.atZone(ZoneId.systemDefault());
        return date.getDayOfMonth();
    }

    public static int monthOf(Object value) {
        Instant i;
        Instant instant = value instanceof Instant ? (i = (Instant)value) : Utilities.timestamp(value);
        ZonedDateTime date = instant.atZone(ZoneId.systemDefault());
        return date.getMonthValue() - 1;
    }

    public static int yearOf(Object value) {
        Instant i;
        Instant instant = value instanceof Instant ? (i = (Instant)value) : Utilities.timestamp(value);
        ZonedDateTime date = instant.atZone(ZoneId.systemDefault());
        return date.getYear();
    }

    public static int hoursOf(Object value) {
        Instant i;
        Instant instant = value instanceof Instant ? (i = (Instant)value) : Utilities.timestamp(value);
        ZonedDateTime date = instant.atZone(ZoneId.systemDefault());
        return date.getHour();
    }

    public static int minutesOf(Object value) {
        Instant i;
        Instant instant = value instanceof Instant ? (i = (Instant)value) : Utilities.timestamp(value);
        ZonedDateTime date = instant.atZone(ZoneId.systemDefault());
        return date.getMinute();
    }

    public static int secondsOf(Object value) {
        Instant i;
        Instant instant = value instanceof Instant ? (i = (Instant)value) : Utilities.timestamp(value);
        ZonedDateTime date = instant.atZone(ZoneId.systemDefault());
        return date.getSecond();
    }

    public static Object max(List<Object> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("max() requires at least one argument");
        }
        Object result = values.get(0);
        for (int i = 1; i < values.size(); ++i) {
            if (Utilities.compare(values.get(i), result) <= 0) continue;
            result = values.get(i);
        }
        return result;
    }

    public static Object min(List<Object> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("min() requires at least one argument");
        }
        Object result = values.get(0);
        for (int i = 1; i < values.size(); ++i) {
            if (Utilities.compare(values.get(i), result) >= 0) continue;
            result = values.get(i);
        }
        return result;
    }

    public static int compare(Object a, Object b) {
        if (a instanceof Number) {
            Number na = (Number)a;
            if (b instanceof Number) {
                Number nb = (Number)b;
                return Double.compare(na.doubleValue(), nb.doubleValue());
            }
        }
        if (a instanceof String) {
            String sa = (String)a;
            if (b instanceof String) {
                String sb = (String)b;
                return sa.compareTo(sb);
            }
        }
        if (a instanceof Instant) {
            Instant ia = (Instant)a;
            if (b instanceof Instant) {
                Instant ib = (Instant)b;
                return ia.compareTo(ib);
            }
        }
        if (a instanceof Comparable) {
            Comparable ca = (Comparable)a;
            if (b instanceof Comparable) {
                Comparable cb = (Comparable)b;
                try {
                    return ca.compareTo(cb);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Cannot compare values of different types");
                }
            }
        }
        throw new IllegalArgumentException("Cannot compare values of different types");
    }
}

