/*
 * Decompiled with CFR 0.152.
 */
package com.mailboxvalidator;

import com.mailboxvalidator.MBVResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SingleValidation {
    private String api_key = "";
    private static final String api_url = "http://api.mailboxvalidator.com/v1/validation/single";
    private static final String api_url2 = "http://api.mailboxvalidator.com/v1/email/disposable";
    private static final String api_url3 = "http://api.mailboxvalidator.com/v1/email/free";
    private static final Pattern jsonpattern = Pattern.compile("(\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"|[0-9\\.\\-]+)", 2);

    public SingleValidation(String apikey) {
        this.api_key = apikey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MBVResult ValidateEmail(String EmailAddress) throws IOException {
        MBVResult record = new MBVResult(EmailAddress);
        try {
            String output;
            Hashtable<String, String> data = new Hashtable<String, String>();
            data.put("format", "json");
            data.put("email", EmailAddress);
            data.put("key", this.api_key);
            String datastr = "";
            for (Map.Entry entry : data.entrySet()) {
                datastr = datastr + "&" + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8");
            }
            datastr = datastr.substring(1);
            URL url = new URL("http://api.mailboxvalidator.com/v1/validation/single?" + datastr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Error connecting to API.");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String output2 = "";
            while ((output = br.readLine()) != null) {
                output2 = output2 + output;
            }
            conn.disconnect();
            ArrayList<String> allMatches = new ArrayList<String>();
            Matcher m = jsonpattern.matcher(output2);
            while (m.find()) {
                allMatches.add(m.group());
            }
            int x = 0;
            int max = allMatches.size();
            String v1 = "";
            String v2 = "";
            x = 0;
            while (true) {
                if (x >= max) {
                    return record;
                }
                v1 = ((String)allMatches.get(x)).substring(1);
                v1 = v1.substring(0, v1.length() - 1);
                v2 = (String)allMatches.get(x + 1);
                if (!v1.equals("credits_available")) {
                    v2 = v2.substring(1);
                    v2 = v2.substring(0, v2.length() - 1);
                }
                switch (v1) {
                    case "email_address": {
                        record.email_address = v2;
                        break;
                    }
                    case "domain": {
                        record.domain = v2;
                        break;
                    }
                    case "is_free": {
                        record.is_free = v2;
                        break;
                    }
                    case "is_syntax": {
                        record.is_syntax = v2;
                        break;
                    }
                    case "is_domain": {
                        record.is_domain = v2;
                        break;
                    }
                    case "is_smtp": {
                        record.is_smtp = v2;
                        break;
                    }
                    case "is_verified": {
                        record.is_verified = v2;
                        break;
                    }
                    case "is_server_down": {
                        record.is_server_down = v2;
                        break;
                    }
                    case "is_greylisted": {
                        record.is_greylisted = v2;
                        break;
                    }
                    case "is_disposable": {
                        record.is_disposable = v2;
                        break;
                    }
                    case "is_suppressed": {
                        record.is_suppressed = v2;
                        break;
                    }
                    case "is_role": {
                        record.is_role = v2;
                        break;
                    }
                    case "is_high_risk": {
                        record.is_high_risk = v2;
                        break;
                    }
                    case "is_catchall": {
                        record.is_catchall = v2;
                        break;
                    }
                    case "mailboxvalidator_score": {
                        record.mailboxvalidator_score = v2.length() > 0 ? Float.parseFloat(v2) : 0.0f;
                        break;
                    }
                    case "time_taken": {
                        record.time_taken = Float.parseFloat(v2);
                        break;
                    }
                    case "status": {
                        record.status = v2;
                        break;
                    }
                    case "credits_available": {
                        v2 = v2.replaceAll("\"", "");
                        record.credits_available = v2.length() > 0 ? Integer.parseInt(v2) : 0;
                        break;
                    }
                    case "error_code": {
                        record.error_code = v2;
                        break;
                    }
                    case "error_message": {
                        record.error_message = v2;
                        break;
                    }
                }
                x += 2;
            }
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MBVResult DisposableEmail(String EmailAddress) throws IOException {
        MBVResult record = new MBVResult(EmailAddress);
        try {
            String output;
            Hashtable<String, String> data = new Hashtable<String, String>();
            data.put("format", "json");
            data.put("email", EmailAddress);
            data.put("key", this.api_key);
            String datastr = "";
            for (Map.Entry entry : data.entrySet()) {
                datastr = datastr + "&" + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8");
            }
            datastr = datastr.substring(1);
            URL url = new URL("http://api.mailboxvalidator.com/v1/email/disposable?" + datastr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Error connecting to API.");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String output2 = "";
            while ((output = br.readLine()) != null) {
                output2 = output2 + output;
            }
            conn.disconnect();
            ArrayList<String> allMatches = new ArrayList<String>();
            Matcher m = jsonpattern.matcher(output2);
            while (m.find()) {
                allMatches.add(m.group());
            }
            int x = 0;
            int max = allMatches.size();
            String v1 = "";
            String v2 = "";
            x = 0;
            while (true) {
                if (x >= max) {
                    return record;
                }
                v1 = ((String)allMatches.get(x)).substring(1);
                v1 = v1.substring(0, v1.length() - 1);
                v2 = (String)allMatches.get(x + 1);
                if (!v1.equals("credits_available")) {
                    v2 = v2.substring(1);
                    v2 = v2.substring(0, v2.length() - 1);
                }
                switch (v1) {
                    case "email_address": {
                        record.email_address = v2;
                        break;
                    }
                    case "is_disposable": {
                        record.is_disposable = v2;
                        break;
                    }
                    case "credits_available": {
                        v2 = v2.replaceAll("\"", "");
                        record.credits_available = v2.length() > 0 ? Integer.parseInt(v2) : 0;
                        break;
                    }
                    case "error_code": {
                        record.error_code = v2;
                        break;
                    }
                    case "error_message": {
                        record.error_message = v2;
                        break;
                    }
                }
                x += 2;
            }
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MBVResult FreeEmail(String EmailAddress) throws IOException {
        MBVResult record = new MBVResult(EmailAddress);
        try {
            String output;
            Hashtable<String, String> data = new Hashtable<String, String>();
            data.put("format", "json");
            data.put("email", EmailAddress);
            data.put("key", this.api_key);
            String datastr = "";
            for (Map.Entry entry : data.entrySet()) {
                datastr = datastr + "&" + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8");
            }
            datastr = datastr.substring(1);
            URL url = new URL("http://api.mailboxvalidator.com/v1/email/free?" + datastr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Error connecting to API.");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String output2 = "";
            while ((output = br.readLine()) != null) {
                output2 = output2 + output;
            }
            conn.disconnect();
            ArrayList<String> allMatches = new ArrayList<String>();
            Matcher m = jsonpattern.matcher(output2);
            while (m.find()) {
                allMatches.add(m.group());
            }
            int x = 0;
            int max = allMatches.size();
            String v1 = "";
            String v2 = "";
            x = 0;
            while (true) {
                if (x >= max) {
                    return record;
                }
                v1 = ((String)allMatches.get(x)).substring(1);
                v1 = v1.substring(0, v1.length() - 1);
                v2 = (String)allMatches.get(x + 1);
                if (!v1.equals("credits_available")) {
                    v2 = v2.substring(1);
                    v2 = v2.substring(0, v2.length() - 1);
                }
                switch (v1) {
                    case "email_address": {
                        record.email_address = v2;
                        break;
                    }
                    case "is_free": {
                        record.is_free = v2;
                        break;
                    }
                    case "credits_available": {
                        v2 = v2.replaceAll("\"", "");
                        record.credits_available = v2.length() > 0 ? Integer.parseInt(v2) : 0;
                        break;
                    }
                    case "error_code": {
                        record.error_code = v2;
                        break;
                    }
                    case "error_message": {
                        record.error_message = v2;
                        break;
                    }
                }
                x += 2;
            }
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
    }
}

