/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.UsageDataStore;
import com.microsoft.java.debug.plugin.internal.DebugSettingUtils;
import com.microsoft.java.debug.plugin.internal.IDebugServer;
import com.microsoft.java.debug.plugin.internal.JavaDebugServer;
import com.microsoft.java.debug.plugin.internal.ResolveClasspathsHandler;
import com.microsoft.java.debug.plugin.internal.ResolveMainClassHandler;
import com.microsoft.java.debug.plugin.internal.ResolveMainMethodHandler;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;

public class JavaDebugDelegateCommandHandler
implements IDelegateCommandHandler {
    public static String FETCH_USER_DATA = "vscode.java.fetchUsageData";
    public static String DEBUG_STARTSESSION = "vscode.java.startDebugSession";
    public static String RESOLVE_CLASSPATH = "vscode.java.resolveClasspath";
    public static String RESOLVE_MAINCLASS = "vscode.java.resolveMainClass";
    public static String BUILD_WORKSPACE = "vscode.java.buildWorkspace";
    public static String UPDATE_DEBUG_SETTINGS = "vscode.java.updateDebugSettings";
    public static String VALIDATE_LAUNCHCONFIG = "vscode.java.validateLaunchConfig";
    public static String RESOLVE_MAINMETHOD = "vscode.java.resolveMainMethod";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor progress) throws Exception {
        if (DEBUG_STARTSESSION.equals(commandId)) {
            IDebugServer debugServer = JavaDebugServer.getInstance();
            debugServer.start();
            return debugServer.getPort();
        }
        if (RESOLVE_CLASSPATH.equals(commandId)) {
            ResolveClasspathsHandler handler = new ResolveClasspathsHandler();
            return handler.resolveClasspaths(arguments);
        }
        if (RESOLVE_MAINCLASS.equals(commandId)) {
            ResolveMainClassHandler handler = new ResolveMainClassHandler();
            return handler.resolveMainClass(arguments);
        }
        if (!BUILD_WORKSPACE.equals(commandId)) {
            if (FETCH_USER_DATA.equals(commandId)) {
                return UsageDataStore.getInstance().fetchAll();
            }
            if (UPDATE_DEBUG_SETTINGS.equals(commandId)) {
                return DebugSettingUtils.configDebugSettings(arguments);
            }
            if (VALIDATE_LAUNCHCONFIG.equals(commandId)) {
                return new ResolveMainClassHandler().validateLaunchConfig(arguments);
            }
            if (RESOLVE_MAINMETHOD.equals(commandId)) {
                return ResolveMainMethodHandler.resolveMainMethods(arguments);
            }
        }
        throw new UnsupportedOperationException(String.format("Java debug plugin doesn't support the command '%s'.", commandId));
    }
}

