/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.debug.core.breakpoints.ValidBreakpointLocationLocator;

public class JdtSourceLookUpProvider
implements ISourceLookUpProvider {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final String JDT_SCHEME = "jdt";
    private static final String PATH_SEPARATOR = "/";
    private ISourceContainer[] sourceContainers = null;
    private HashMap<String, Object> options = new HashMap();

    public void initialize(IDebugAdapterContext context, Map<String, Object> props) {
        if (props == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.options.putAll(props);
        new Thread(() -> this.getSourceContainers()).start();
    }

    public boolean supportsRealtimeBreakpointVerification() {
        return true;
    }

    public String[] getFullyQualifiedName(String uri, int[] lines, int[] columns) throws DebugException {
        if (uri == null) {
            throw new IllegalArgumentException("sourceFilePath is null");
        }
        if (lines == null) {
            throw new IllegalArgumentException("lines is null");
        }
        if (columns == null) {
            columns = new int[lines.length];
        } else if (lines.length != columns.length) {
            throw new IllegalArgumentException("the count of lines and columns don't match!");
        }
        if (lines.length == 0) {
            return new String[0];
        }
        ASTParser parser = ASTParser.newParser((int)13);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setStatementsRecovery(true);
        CompilationUnit astUnit = null;
        String filePath = AdapterUtils.toPath((String)uri);
        if (filePath != null && Files.isRegularFile(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            Charset cs = (Charset)this.options.get("debuggeeEncoding");
            if (cs == null) {
                cs = Charset.defaultCharset();
            }
            String source = JdtSourceLookUpProvider.readFile(filePath, cs);
            parser.setSource(source.toCharArray());
            parser.setEnvironment(new String[0], new String[0], null, true);
            parser.setUnitName(Paths.get(filePath, new String[0]).getFileName().toString());
            Hashtable javaOptions = JavaCore.getOptions();
            javaOptions.put("org.eclipse.jdt.core.compiler.source", "13");
            javaOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "13");
            javaOptions.put("org.eclipse.jdt.core.compiler.compliance", "13");
            parser.setCompilerOptions((Map)javaOptions);
            astUnit = (CompilationUnit)parser.createAST(null);
        } else {
            IClassFile typeRoot = JdtSourceLookUpProvider.resolveClassFile(uri);
            if (typeRoot != null) {
                parser.setSource((ITypeRoot)typeRoot);
                astUnit = (CompilationUnit)parser.createAST(null);
            }
        }
        String[] fqns = new String[lines.length];
        if (astUnit != null) {
            int i = 0;
            while (i < lines.length) {
                ValidBreakpointLocationLocator locator = new ValidBreakpointLocationLocator(astUnit, lines[i], true, true);
                astUnit.accept((ASTVisitor)locator);
                if (lines[i] == locator.getLineLocation() && locator.getLocationType() == 1) {
                    fqns[i] = locator.getFullyQualifiedTypeName();
                }
                ++i;
            }
        }
        return fqns;
    }

    public String getSourceFileURI(String fullyQualifiedName, String sourcePath) {
        if (sourcePath == null) {
            return null;
        }
        Object sourceElement = JdtUtils.findSourceElement(sourcePath, this.getSourceContainers());
        if (sourceElement instanceof IResource) {
            return JdtSourceLookUpProvider.getFileURI((IResource)sourceElement);
        }
        if (sourceElement instanceof IClassFile) {
            try {
                IClassFile file = (IClassFile)sourceElement;
                if (file.getBuffer() != null) {
                    return JdtSourceLookUpProvider.getFileURI(file);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public synchronized ISourceContainer[] getSourceContainers() {
        if (this.sourceContainers == null) {
            this.sourceContainers = JdtUtils.getSourceContainers((String)this.options.get("projectName"));
        }
        return this.sourceContainers;
    }

    public String getSourceContents(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        IClassFile cf = JdtSourceLookUpProvider.resolveClassFile(uri);
        return this.getContents(cf);
    }

    private String getContents(IClassFile cf) {
        String source = null;
        if (cf != null) {
            try {
                IBuffer buffer = cf.getBuffer();
                if (buffer != null) {
                    source = buffer.getContents();
                }
            }
            catch (JavaModelException e) {
                logger.log(Level.SEVERE, String.format("Failed to parse the source contents of the class file: %s", e.toString()), e);
            }
            if (source == null) {
                source = "";
            }
        }
        return source;
    }

    private static String getFileURI(IClassFile classFile) {
        String packageName = classFile.getParent().getElementName();
        String jarName = classFile.getParent().getParent().getElementName();
        try {
            return new URI(JDT_SCHEME, "contents", PATH_SEPARATOR + jarName + PATH_SEPARATOR + packageName + PATH_SEPARATOR + classFile.getElementName(), classFile.getHandleIdentifier(), null).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private static String getFileURI(IResource resource) {
        URI uri = resource.getLocationURI();
        if (uri != null) {
            String uriString = uri.toASCIIString();
            return uriString.replaceFirst("file:/([^/])", "file:///$1");
        }
        return null;
    }

    private static IClassFile resolveClassFile(String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if (uri != null && JDT_SCHEME.equals(uri.getScheme()) && "contents".equals(uri.getAuthority())) {
                String handleId = uri.getQuery();
                IJavaElement element = JavaCore.create((String)handleId);
                IClassFile cf = (IClassFile)element.getAncestor(6);
                return cf;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    private static String readFile(String filePath, Charset cs) {
        StringBuilder builder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader bufferReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), cs));){
                int read;
                char[] buffer = new char[4096];
                while ((read = bufferReader.read(buffer, 0, 4096)) != -1) {
                    builder.append(new String(buffer, 0, read));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return builder.toString();
    }
}

