/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.debug.core.breakpoints.ValidBreakpointLocationLocator;

public class BreakpointLocationLocator
extends ValidBreakpointLocationLocator {
    private IMethodBinding methodBinding;

    public BreakpointLocationLocator(CompilationUnit compilationUnit, int lineNumber, boolean bindingsResolved, boolean bestMatch) {
        super(compilationUnit, lineNumber, bindingsResolved, bestMatch);
    }

    public boolean visit(MethodDeclaration node) {
        boolean result = super.visit(node);
        if (this.methodBinding == null && this.getLocationType() == 2) {
            this.methodBinding = node.resolveBinding();
        }
        return result;
    }

    public String getMethodSignature() {
        if (this.methodBinding == null) {
            return null;
        }
        return BreakpointLocationLocator.toSignature(this.methodBinding, this.getMethodName());
    }

    public String getMethodName() {
        if (this.methodBinding == null) {
            return null;
        }
        return this.methodBinding.getName();
    }

    public String getFullyQualifiedTypeName() {
        if (this.methodBinding != null) {
            return this.methodBinding.getDeclaringClass().getQualifiedName();
        }
        return super.getFullyQualifiedTypeName();
    }

    static String toSignature(IMethodBinding binding, String name) {
        int index;
        String signatureString = binding.getKey();
        if (signatureString != null && (index = signatureString.indexOf(name)) > -1) {
            int exceptionIndex = signatureString.indexOf("|", signatureString.lastIndexOf(")"));
            if (exceptionIndex > -1) {
                return signatureString.substring(index + name.length(), exceptionIndex);
            }
            return signatureString.substring(index + name.length());
        }
        return null;
    }
}

