/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug;

import com.microsoft.java.debug.BreakpointLocationLocator;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;

public class LambdaExpressionLocator
extends ASTVisitor {
    private CompilationUnit compilationUnit;
    private int line;
    private int column;
    private boolean found;
    private IMethodBinding lambdaMethodBinding;
    private LambdaExpression lambdaExpression;

    public LambdaExpressionLocator(CompilationUnit compilationUnit, int line, int column) {
        this.compilationUnit = compilationUnit;
        this.line = line;
        this.column = column;
    }

    public boolean visit(LambdaExpression node) {
        if (this.column > -1) {
            int startPosition = node.getStartPosition();
            int endPosition = node.getBody().getStartPosition();
            int offset = this.compilationUnit.getPosition(this.line, this.column);
            if (offset >= startPosition && offset <= endPosition) {
                this.lambdaMethodBinding = node.resolveMethodBinding();
                this.found = true;
                this.lambdaExpression = node;
                return false;
            }
        }
        return super.visit(node);
    }

    public boolean isFound() {
        return this.found;
    }

    public String getMethodSignature() {
        if (!this.found) {
            return null;
        }
        return BreakpointLocationLocator.toSignature(this.lambdaMethodBinding, this.getMethodName());
    }

    public String getMethodName() {
        if (!this.found) {
            return null;
        }
        String key = this.lambdaMethodBinding.getKey();
        return key.substring(key.indexOf(46) + 1, key.indexOf(40));
    }

    public String getFullyQualifiedTypeName() {
        if (this.found) {
            ASTNode parent = this.lambdaExpression.getParent();
            while (parent != null) {
                if (parent instanceof AbstractTypeDeclaration) {
                    AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)parent;
                    return declaration.resolveBinding().getBinaryName();
                }
                parent = parent.getParent();
            }
        }
        return null;
    }
}

