/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.BindingUtils;
import com.microsoft.java.debug.BreakpointLocationLocator;
import com.microsoft.java.debug.LambdaExpressionLocator;
import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.JavaBreakpointLocation;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.protocol.Types;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.microsoft.java.debug.plugin.internal.MethodInvocationLocator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.ls.core.internal.JDTUtils;

public class JdtSourceLookUpProvider
implements ISourceLookUpProvider {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final String JDT_SCHEME = "jdt";
    private static final String PATH_SEPARATOR = "/";
    private ISourceContainer[] sourceContainers = null;
    private HashMap<String, Object> options = new HashMap();
    private String latestJavaVersion = JavaCore.latestSupportedJavaVersion();
    private int latestASTLevel;

    public JdtSourceLookUpProvider() {
        Hashtable javaOptions = JavaCore.getOptions();
        javaOptions.put("org.eclipse.jdt.core.compiler.source", this.latestJavaVersion);
        this.latestASTLevel = new AST((Map)javaOptions).apiLevel();
    }

    public void initialize(IDebugAdapterContext context, Map<String, Object> props) {
        if (props == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.options.putAll(props);
        new Thread(() -> this.getSourceContainers()).start();
    }

    public boolean supportsRealtimeBreakpointVerification() {
        return true;
    }

    public String[] getFullyQualifiedName(String uri, int[] lines, int[] columns) throws DebugException {
        if (uri == null) {
            throw new IllegalArgumentException("sourceFilePath is null");
        }
        if (lines == null) {
            throw new IllegalArgumentException("lines is null");
        }
        if (columns == null) {
            columns = new int[lines.length];
        } else if (lines.length != columns.length) {
            throw new IllegalArgumentException("the count of lines and columns don't match!");
        }
        if (lines.length == 0) {
            return new String[0];
        }
        Types.SourceBreakpoint[] sourceBreakpoints = new Types.SourceBreakpoint[lines.length];
        int i = 0;
        while (i < lines.length) {
            sourceBreakpoints[i] = new Types.SourceBreakpoint(lines[i], columns[i]);
            ++i;
        }
        JavaBreakpointLocation[] locations = this.getBreakpointLocations(uri, sourceBreakpoints);
        return (String[])Stream.of(locations).map(location -> {
            if (location.className() != null && location.methodName() != null) {
                return location.className().concat("#").concat(location.methodName()).concat("#").concat(location.methodSignature());
            }
            return location.className();
        }).toArray(String[]::new);
    }

    public JavaBreakpointLocation[] getBreakpointLocations(String sourceUri, Types.SourceBreakpoint[] sourceBreakpoints) throws DebugException {
        if (sourceUri == null) {
            throw new IllegalArgumentException("sourceUri is null");
        }
        if (sourceBreakpoints == null || sourceBreakpoints.length == 0) {
            return new JavaBreakpointLocation[0];
        }
        CompilationUnit astUnit = this.asCompilationUnit(sourceUri);
        JavaBreakpointLocation[] sourceLocations = (JavaBreakpointLocation[])Stream.of(sourceBreakpoints).map(sourceBreakpoint -> new JavaBreakpointLocation(sourceBreakpoint.line, sourceBreakpoint.column)).toArray(JavaBreakpointLocation[]::new);
        if (astUnit != null) {
            HashMap<Integer, Types.BreakpointLocation[]> resolvedLocations = new HashMap<Integer, Types.BreakpointLocation[]>();
            JavaBreakpointLocation[] javaBreakpointLocationArray = sourceLocations;
            int n = sourceLocations.length;
            int n2 = 0;
            while (n2 < n) {
                Types.BreakpointLocation[] inlineLocations;
                JavaBreakpointLocation sourceLocation = javaBreakpointLocationArray[n2];
                int sourceLine = sourceLocation.lineNumber();
                int sourceColumn = sourceLocation.columnNumber();
                if (sourceColumn > -1) {
                    LambdaExpressionLocator lambdaExpressionLocator = new LambdaExpressionLocator(astUnit, sourceLine, sourceColumn);
                    astUnit.accept((ASTVisitor)lambdaExpressionLocator);
                    if (lambdaExpressionLocator.isFound()) {
                        sourceLocation.setClassName(lambdaExpressionLocator.getFullyQualifiedTypeName());
                        sourceLocation.setMethodName(lambdaExpressionLocator.getMethodName());
                        sourceLocation.setMethodSignature(lambdaExpressionLocator.getMethodSignature());
                    }
                    if (resolvedLocations.containsKey(sourceLine)) {
                        sourceLocation.setAvailableBreakpointLocations((Types.BreakpointLocation[])resolvedLocations.get(sourceLine));
                    } else {
                        inlineLocations = this.getInlineBreakpointLocations(astUnit, sourceLine);
                        sourceLocation.setAvailableBreakpointLocations(inlineLocations);
                        resolvedLocations.put(sourceLine, inlineLocations);
                    }
                } else {
                    BreakpointLocationLocator locator = new BreakpointLocationLocator(astUnit, sourceLine, true, true);
                    astUnit.accept((ASTVisitor)locator);
                    if (sourceLine == locator.getLineLocation() && locator.getLocationType() == 1) {
                        sourceLocation.setClassName(locator.getFullyQualifiedTypeName());
                        if (resolvedLocations.containsKey(sourceLine)) {
                            sourceLocation.setAvailableBreakpointLocations((Types.BreakpointLocation[])resolvedLocations.get(sourceLine));
                        } else {
                            inlineLocations = this.getInlineBreakpointLocations(astUnit, sourceLine);
                            sourceLocation.setAvailableBreakpointLocations(inlineLocations);
                            resolvedLocations.put(sourceLine, inlineLocations);
                        }
                    } else if (locator.getLocationType() == 2) {
                        sourceLocation.setClassName(locator.getFullyQualifiedTypeName());
                        sourceLocation.setMethodName(locator.getMethodName());
                        sourceLocation.setMethodSignature(locator.getMethodSignature());
                    }
                }
                ++n2;
            }
        }
        return sourceLocations;
    }

    private Types.BreakpointLocation[] getInlineBreakpointLocations(final CompilationUnit astUnit, final int sourceLine) {
        final ArrayList<Types.BreakpointLocation> locations = new ArrayList<Types.BreakpointLocation>();
        locations.add(new Types.BreakpointLocation(sourceLine, 0));
        astUnit.accept(new ASTVisitor(){

            public boolean visit(LambdaExpression node) {
                int lambdaStart = node.getStartPosition();
                int startLine = astUnit.getLineNumber(lambdaStart);
                if (startLine == sourceLine) {
                    int startColumn = astUnit.getColumnNumber(lambdaStart);
                    int lambdaEnd = lambdaStart + node.getLength();
                    int endLine = astUnit.getLineNumber(lambdaEnd);
                    int endColumn = astUnit.getColumnNumber(lambdaEnd);
                    Types.BreakpointLocation location = new Types.BreakpointLocation(startLine, startColumn, endLine, endColumn);
                    locations.add(location);
                }
                return super.visit(node);
            }
        });
        return (Types.BreakpointLocation[])locations.toArray(Types.BreakpointLocation[]::new);
    }

    private CompilationUnit asCompilationUnit(String uri) {
        ASTParser parser = ASTParser.newParser((int)this.latestASTLevel);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setStatementsRecovery(true);
        CompilationUnit astUnit = null;
        String filePath = AdapterUtils.toPath((String)uri);
        if (filePath != null && Files.isRegularFile(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            String source = JdtSourceLookUpProvider.readFile(filePath);
            parser.setSource(source.toCharArray());
            parser.setEnvironment(new String[0], new String[0], null, true);
            parser.setUnitName(Paths.get(filePath, new String[0]).getFileName().toString());
            Hashtable javaOptions = JavaCore.getOptions();
            javaOptions.put("org.eclipse.jdt.core.compiler.source", this.latestJavaVersion);
            javaOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.latestJavaVersion);
            javaOptions.put("org.eclipse.jdt.core.compiler.compliance", this.latestJavaVersion);
            javaOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
            parser.setCompilerOptions((Map)javaOptions);
            astUnit = (CompilationUnit)parser.createAST(null);
        } else {
            IClassFile typeRoot = JdtSourceLookUpProvider.resolveClassFile(uri);
            if (typeRoot != null) {
                parser.setSource((ITypeRoot)typeRoot);
                astUnit = (CompilationUnit)parser.createAST(null);
            }
        }
        return astUnit;
    }

    public String getSourceFileURI(String fullyQualifiedName, String sourcePath) {
        if (sourcePath == null) {
            return null;
        }
        Object sourceElement = JdtUtils.findSourceElement(sourcePath, this.getSourceContainers());
        if (sourceElement instanceof IResource) {
            return JdtSourceLookUpProvider.getFileURI((IResource)sourceElement);
        }
        if (sourceElement instanceof IClassFile) {
            return JdtSourceLookUpProvider.getFileURI((IClassFile)sourceElement);
        }
        return null;
    }

    public String getJavaRuntimeVersion(String projectName) {
        IJavaProject project = JdtUtils.getJavaProject(projectName);
        if (project != null) {
            IVMInstall vmInstall;
            block4: {
                vmInstall = JavaRuntime.getVMInstall((IJavaProject)project);
                if (vmInstall != null && vmInstall.getInstallLocation() != null) break block4;
                return null;
            }
            try {
                return JdtSourceLookUpProvider.resolveSystemLibraryVersion(project, vmInstall);
            }
            catch (CoreException e) {
                logger.log(Level.SEVERE, "Failed to get Java runtime version for project '" + projectName + "': " + e.getMessage(), e);
            }
        }
        return null;
    }

    public synchronized ISourceContainer[] getSourceContainers() {
        if (this.sourceContainers == null) {
            this.sourceContainers = JdtUtils.getSourceContainers((String)this.options.get("projectName"));
        }
        return this.sourceContainers;
    }

    public String getSourceContents(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        IClassFile cf = JdtSourceLookUpProvider.resolveClassFile(uri);
        return this.getContents(cf);
    }

    private String getContents(IClassFile cf) {
        String source = null;
        if (cf != null) {
            try {
                IBuffer buffer = cf.getBuffer();
                if (buffer != null) {
                    source = buffer.getContents();
                }
            }
            catch (JavaModelException e) {
                logger.log(Level.SEVERE, String.format("Failed to parse the source contents of the class file: %s", e.toString()), e);
            }
            if (source == null) {
                source = "";
            }
        }
        return source;
    }

    private static String getFileURI(IClassFile classFile) {
        String packageName = classFile.getParent().getElementName();
        String jarName = classFile.getParent().getParent().getElementName();
        try {
            return new URI(JDT_SCHEME, "contents", PATH_SEPARATOR + jarName + PATH_SEPARATOR + packageName + PATH_SEPARATOR + classFile.getElementName(), classFile.getHandleIdentifier(), null).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private static String getFileURI(IResource resource) {
        URI uri = resource.getLocationURI();
        if (uri != null) {
            String uriString = uri.toASCIIString();
            return uriString.replaceFirst("file:/([^/])", "file:///$1");
        }
        return null;
    }

    private static IClassFile resolveClassFile(String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if (uri != null && JDT_SCHEME.equals(uri.getScheme()) && "contents".equals(uri.getAuthority())) {
                String handleId = uri.getQuery();
                IJavaElement element = JavaCore.create((String)handleId);
                IClassFile cf = (IClassFile)element.getAncestor(6);
                return cf;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    private static String readFile(String filePath) {
        StringBuilder builder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader bufferReader = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));){
                int read;
                char[] buffer = new char[4096];
                while ((read = bufferReader.read(buffer, 0, 4096)) != -1) {
                    builder.append(new String(buffer, 0, read));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return builder.toString();
    }

    private static String resolveSystemLibraryVersion(IJavaProject project, IVMInstall vmInstall) throws JavaModelException {
        LibraryLocation[] libraries = JavaRuntime.getLibraryLocations((IVMInstall)vmInstall);
        if (libraries != null && libraries.length > 0) {
            IPackageFragmentRoot root = project.findPackageFragmentRoot(libraries[0].getSystemLibraryPath());
            if (!(root instanceof JarPackageFragmentRoot)) {
                return null;
            }
            Manifest manifest = ((JarPackageFragmentRoot)root).getManifest();
            if (manifest == null) {
                return null;
            }
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue("Implementation-Version");
        }
        return null;
    }

    public List<ISourceLookUpProvider.MethodInvocation> findMethodInvocations(String uri, int line) {
        CompilationUnit astUnit;
        ITypeRoot cachedElement;
        if (uri == null) {
            return Collections.emptyList();
        }
        boolean useCache = false;
        CompilationUnit cachedUnit = CoreASTProvider.getInstance().getCachedAST();
        if (cachedUnit != null && (cachedElement = cachedUnit.getTypeRoot()) != null && this.isSameURI(JDTUtils.toUri((ITypeRoot)cachedElement), uri)) {
            useCache = true;
        }
        CompilationUnit compilationUnit = astUnit = useCache ? cachedUnit : this.asCompilationUnit(uri);
        if (astUnit == null) {
            return Collections.emptyList();
        }
        MethodInvocationLocator locator = new MethodInvocationLocator(line, astUnit);
        astUnit.accept((ASTVisitor)locator);
        return locator.getTargets().entrySet().stream().map(entry -> {
            ISourceLookUpProvider.MethodInvocation invocation = new ISourceLookUpProvider.MethodInvocation();
            ASTNode astNode = (ASTNode)entry.getKey();
            invocation.expression = astNode.toString();
            IMethodBinding binding = ((IMethodBinding)entry.getValue()).getMethodDeclaration();
            String string = invocation.methodName = binding.isConstructor() ? "<init>" : binding.getName();
            if (binding.getDeclaringClass().isAnonymous()) {
                ITypeBinding superclass = binding.getDeclaringClass().getSuperclass();
                if (superclass == null || superclass.isEqualTo((IBinding)astUnit.getAST().resolveWellKnownType("java.lang.Object"))) return null;
                invocation.declaringTypeName = superclass.getBinaryName();
            } else {
                invocation.declaringTypeName = binding.getDeclaringClass().getBinaryName();
            }
            invocation.methodGenericSignature = BindingUtils.toSignature(binding, BindingUtils.getMethodName(binding, true));
            invocation.methodSignature = Signature.getTypeErasure((String)invocation.methodGenericSignature);
            int startOffset = astNode.getStartPosition();
            if (astNode instanceof MethodInvocation) {
                startOffset = ((MethodInvocation)astNode).getName().getStartPosition();
            }
            invocation.lineStart = astUnit.getLineNumber(startOffset);
            invocation.columnStart = astUnit.getColumnNumber(startOffset);
            int endOffset = astNode.getStartPosition() + astNode.getLength();
            invocation.lineEnd = astUnit.getLineNumber(endOffset);
            invocation.columnEnd = astUnit.getColumnNumber(endOffset);
            return invocation;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean isSameURI(String uri1, String uri2) {
        if (Objects.equals(uri1, uri2)) {
            return true;
        }
        try {
            return URIUtil.sameURI((URI)new URI(uri1), (URI)new URI(uri2));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }
}

