/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal.eval;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ASTEvaluationEngine;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;

public class JdtEvaluationProvider
implements IEvaluationProvider {
    private static final Logger logger = Logger.getLogger("java-debug");
    private IJavaProject project;
    private ILaunch launch;
    private JDIDebugTarget debugTarget;
    private Map<ThreadReference, JDIThread> threadMap = new HashMap<ThreadReference, JDIThread>();
    private HashMap<String, Object> options = new HashMap();
    private IDebugAdapterContext context;

    public void initialize(IDebugAdapterContext context, Map<String, Object> props) {
        if (props == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.options.putAll(props);
        this.context = context;
    }

    public CompletableFuture<Value> evaluate(String expression, ThreadReference thread, int depth) {
        JDIThread jdiThread;
        JDIStackFrame stackframe;
        CompletableFuture<Value> completableFuture = new CompletableFuture<Value>();
        String projectName = (String)this.options.get("projectName");
        if (this.debugTarget == null) {
            if (this.project == null) {
                if (StringUtils.isBlank((CharSequence)projectName)) {
                    logger.severe("Cannot evaluate when project is not specified.");
                    completableFuture.completeExceptionally(new IllegalStateException("Please specify projectName in launch.json."));
                    return completableFuture;
                }
                this.project = JdtUtils.getJavaProject(projectName);
            }
            if (this.project == null) {
                completableFuture.completeExceptionally(new IllegalStateException(String.format("Project %s cannot be found.", projectName)));
                return completableFuture;
            }
            if (this.launch == null) {
                this.launch = JdtEvaluationProvider.createILaunchMock(this.project);
            }
        }
        if (this.debugTarget == null) {
            this.debugTarget = new JDIDebugTarget(this.launch, thread.virtualMachine(), "", false, false, null, false){

                protected synchronized void initialize() {
                }
            };
        }
        if ((stackframe = this.createStackFrame(jdiThread = this.getMockJDIThread(thread), depth)) == null) {
            logger.severe("Cannot evaluate because the stackframe is not available.");
            completableFuture.completeExceptionally(new IllegalStateException("Cannot evaluate because the stackframe is not available."));
            return completableFuture;
        }
        try {
            ASTEvaluationEngine engine = new ASTEvaluationEngine(this.project, (IJavaDebugTarget)this.debugTarget);
            ICompiledExpression ie = engine.getCompiledExpression(expression, (IJavaStackFrame)stackframe);
            engine.evaluateExpression(ie, (IJavaStackFrame)stackframe, evaluateResult -> {
                if (evaluateResult == null || evaluateResult.hasErrors()) {
                    Object ex = evaluateResult.getException() != null ? evaluateResult.getException() : new RuntimeException(StringUtils.join((Object[])evaluateResult.getErrorMessages()));
                    completableFuture.completeExceptionally((Throwable)ex);
                    return;
                }
                try {
                    Value value = (Value)FieldUtils.readField((Object)evaluateResult.getValue(), (String)"fValue", (boolean)true);
                    completableFuture.complete(value);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    completableFuture.completeExceptionally(ex);
                }
            }, 0, false);
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
        }
        return completableFuture;
    }

    private JDIStackFrame createStackFrame(JDIThread thread, int depth) {
        try {
            IStackFrame[] jdiStackFrames = thread.getStackFrames();
            return jdiStackFrames.length > depth ? (JDIStackFrame)jdiStackFrames[depth] : null;
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDIThread getMockJDIThread(final ThreadReference thread) {
        Map<ThreadReference, JDIThread> map = this.threadMap;
        synchronized (map) {
            return this.threadMap.computeIfAbsent(thread, threadKey -> new JDIThread(this.debugTarget, thread){

                protected synchronized void invokeComplete(int restoreTimeout) {
                    super.invokeComplete(restoreTimeout);
                    JdtEvaluationProvider.this.context.getStackFrameManager().reloadStackFrames(thread);
                }
            });
        }
    }

    public boolean isInEvaluation(ThreadReference thread) {
        return this.debugTarget != null && this.getMockJDIThread(thread).isPerformingEvaluation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState(ThreadReference thread) {
        if (this.debugTarget != null) {
            Map<ThreadReference, JDIThread> map = this.threadMap;
            synchronized (map) {
                JDIThread jdiThread = this.threadMap.get(thread);
                if (jdiThread != null) {
                    try {
                        jdiThread.terminateEvaluation();
                    }
                    catch (DebugException e) {
                        logger.warning(String.format("Error stopping evalutoin on thread %d: %s", thread.uniqueID(), e.toString()));
                    }
                    this.threadMap.remove(thread);
                }
            }
        }
    }

    private static ILaunch createILaunchMock(final IJavaProject project) {
        return new ILaunch(){
            private AbstractSourceLookupDirector locator;

            public boolean canTerminate() {
                return false;
            }

            public boolean isTerminated() {
                return false;
            }

            public void terminate() throws DebugException {
            }

            public <T> T getAdapter(Class<T> arg0) {
                return null;
            }

            public void addDebugTarget(IDebugTarget arg0) {
            }

            public void addProcess(IProcess arg0) {
            }

            public String getAttribute(String arg0) {
                return null;
            }

            public Object[] getChildren() {
                return null;
            }

            public IDebugTarget getDebugTarget() {
                return null;
            }

            public IDebugTarget[] getDebugTargets() {
                return null;
            }

            public ILaunchConfiguration getLaunchConfiguration() {
                return null;
            }

            public String getLaunchMode() {
                return null;
            }

            public IProcess[] getProcesses() {
                return null;
            }

            public ISourceLocator getSourceLocator() {
                if (this.locator != null) {
                    return this.locator;
                }
                this.locator = new JavaSourceLookupDirector();
                try {
                    this.locator.setSourceContainers(new ProjectSourceContainer(project.getProject(), true).getSourceContainers());
                }
                catch (CoreException e) {
                    logger.severe(String.format("Cannot initialize JavaSourceLookupDirector: %s", e.toString()));
                }
                this.locator.initializeParticipants();
                return this.locator;
            }

            public boolean hasChildren() {
                return false;
            }

            public void removeDebugTarget(IDebugTarget arg0) {
            }

            public void removeProcess(IProcess arg0) {
            }

            public void setAttribute(String arg0, String arg1) {
            }

            public void setSourceLocator(ISourceLocator arg0) {
            }
        };
    }
}

