/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.edgate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nfbsoftware.edgate.model.Concept;
import com.nfbsoftware.edgate.model.ConceptStandards;
import com.nfbsoftware.edgate.model.Profile;
import com.nfbsoftware.edgate.model.Standard;
import com.nfbsoftware.edgate.model.StandardsSet;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class EdGateClient {
    private static final Log logger = LogFactory.getLog(EdGateClient.class);
    private static final String HASH_ALGORITHM = "HmacSHA256";
    private static final String HOST_DOMAIN = "api.edgate.com";
    private static final int HOST_PORT = 443;
    private static final String HOST_SCHEME = "https";
    private String m_privateKey;
    private String m_publicKey;

    public EdGateClient(String publicKey, String privateKey) {
        this.m_publicKey = publicKey;
        this.m_privateKey = privateKey;
    }

    public Profile getProfile() throws Exception {
        Profile profileValue = null;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/profile?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            ObjectMapper mapper = new ObjectMapper();
            profileValue = (Profile)mapper.readValue(responseString, Profile.class);
        }
        return profileValue;
    }

    public List<Standard> getAvailableStandards() throws Exception {
        ArrayList<Standard> standardsList = new ArrayList<Standard>();
        Profile tmpProfile = this.getProfile();
        for (StandardsSet tmpStandardsSet : tmpProfile.getStandardsSets()) {
            List<Standard> rootStandardsList = this.getStandardsRoot(tmpStandardsSet.getSetId());
            for (Standard rootStandard : rootStandardsList) {
                standardsList.add(rootStandard);
            }
        }
        return standardsList;
    }

    public List<StandardsSet> getStandardSets() throws Exception {
        List<StandardsSet> standardsSetList = new ArrayList<StandardsSet>();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/standards?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            ObjectMapper mapper = new ObjectMapper();
            standardsSetList = (List)mapper.readValue(responseString, (TypeReference)new TypeReference<List<StandardsSet>>(){});
        }
        return standardsSetList;
    }

    public StandardsSet getStandardSet(String setId) throws Exception {
        StandardsSet standardsSet = null;
        List<StandardsSet> tmpStandardsSetList = this.getStandardSets();
        for (StandardsSet tmpStandardsSet : tmpStandardsSetList) {
            if (!tmpStandardsSet.getSetId().equalsIgnoreCase(setId)) continue;
            standardsSet = tmpStandardsSet;
            break;
        }
        return standardsSet;
    }

    public List<Standard> getStandardsRoot(String setId) throws Exception {
        List<Standard> standardsList = new ArrayList<Standard>();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/standards/root/" + setId + "?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            ObjectMapper mapper = new ObjectMapper();
            standardsList = (List)mapper.readValue(responseString, (TypeReference)new TypeReference<List<Standard>>(){});
        }
        return standardsList;
    }

    public Standard getStandard(String guid) throws Exception {
        Standard standardObject = null;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/standards/" + guid + "?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            ObjectMapper mapper = new ObjectMapper();
            standardObject = (Standard)mapper.readValue(responseString, (TypeReference)new TypeReference<Standard>(){});
        }
        return standardObject;
    }

    public List<Standard> getStandardsChildren(String guid) throws Exception {
        List<Standard> standardsList = new ArrayList<Standard>();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/standards/" + guid + "/children?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            ObjectMapper mapper = new ObjectMapper();
            standardsList = (List)mapper.readValue(responseString, (TypeReference)new TypeReference<List<Standard>>(){});
        }
        return standardsList;
    }

    public List<Standard> getRelatedStandards(String guid, String setId) throws Exception {
        List<Standard> standardsList = new ArrayList<Standard>();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("set", setId);
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/standards/related/" + guid + "?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            ObjectMapper mapper = new ObjectMapper();
            standardsList = (List)mapper.readValue(responseString, (TypeReference)new TypeReference<List<Standard>>(){});
        }
        return standardsList;
    }

    public List<Concept> getStandardsConcepts(String guid) throws Exception {
        List<Concept> conceptList = new ArrayList<Concept>();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/standards/concepts/" + guid + "?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            ObjectMapper mapper = new ObjectMapper();
            conceptList = (List)mapper.readValue(responseString, (TypeReference)new TypeReference<List<Concept>>(){});
        }
        return conceptList;
    }

    public List<Concept> getConcepts() throws Exception {
        List<Concept> conceptList = new ArrayList<Concept>();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/concepts/browse?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            ObjectMapper mapper = new ObjectMapper();
            conceptList = (List)mapper.readValue(responseString, (TypeReference)new TypeReference<List<Concept>>(){});
        }
        return conceptList;
    }

    public Concept getConcept(String guid) throws Exception {
        Concept conceptObj = null;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/concepts/" + guid + "?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            ObjectMapper mapper = new ObjectMapper();
            conceptObj = (Concept)mapper.readValue(responseString, Concept.class);
        }
        return conceptObj;
    }

    public ConceptStandards getConceptStandards(String guid, String setId, String gradeLevel) throws Exception {
        ConceptStandards conceptStandardsObj = null;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("set", setId);
        if (StringUtils.isNotBlank((String)gradeLevel)) {
            parameterMap.put("grade", gradeLevel);
        }
        String parameterString = this.createParameterString(parameterMap);
        String parameterHash = this.getSignatureHash(parameterString);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(HOST_DOMAIN, 443, HOST_SCHEME);
        HttpGet getRequest = new HttpGet("/concepts/standards/" + guid + "?" + parameterString);
        getRequest.setHeader("X-Hash", parameterHash);
        HttpResponse apiResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = apiResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            System.out.println(responseString);
            if (responseString.length() > 2) {
                ObjectMapper mapper = new ObjectMapper();
                conceptStandardsObj = (ConceptStandards)mapper.readValue(responseString, ConceptStandards.class);
            }
        }
        return conceptStandardsObj;
    }

    private String createParameterString(HashMap<String, String> parameterMap) throws Exception {
        long unixTimestamp = Instant.now().getEpochSecond();
        StringBuffer parameterBuffer = new StringBuffer();
        parameterBuffer.append("publicKey=" + this.m_publicKey);
        parameterBuffer.append("&timestamp=" + unixTimestamp);
        for (String parameterKey : parameterMap.keySet()) {
            parameterBuffer.append("&" + parameterKey + "=" + URLEncoder.encode(parameterMap.get(parameterKey), StandardCharsets.UTF_8));
        }
        return parameterBuffer.toString();
    }

    private String getSignatureHash(String parameterString) {
        String hash = null;
        try {
            Mac sha256HMAC = Mac.getInstance(HASH_ALGORITHM);
            SecretKeySpec secretKey = new SecretKeySpec(this.m_privateKey.getBytes(), HASH_ALGORITHM);
            sha256HMAC.init(secretKey);
            byte[] result = sha256HMAC.doFinal(parameterString.getBytes());
            hash = DatatypeConverter.printHexBinary((byte[])result).toLowerCase();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        return hash;
    }
}

