/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.util;

public final class Severity {
    public static final int FATAL = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    public static final int INFORMATIONAL = 4;
    public static final int SUCCESS = 5;
    public static final int DEBUG = 6;

    public static String asString(int severity) {
        switch (severity) {
            case 1: {
                return "F";
            }
            case 2: {
                return "E";
            }
            case 3: {
                return "W";
            }
            case 4: {
                return "I";
            }
            case 5: {
                return "S";
            }
            case 6: {
                return "D";
            }
        }
        return "E";
    }

    public static int asInt(String severityStr) {
        switch (Character.toUpperCase(severityStr.charAt(0))) {
            case 'F': {
                return 1;
            }
            case 'E': {
                return 2;
            }
            case 'W': {
                return 3;
            }
            case 'I': {
                return 4;
            }
            case 'S': {
                return 5;
            }
            case 'D': {
                return 6;
            }
        }
        return 2;
    }

    public static boolean isFailure(int severity) {
        return severity <= 3;
    }

    public static boolean isSuccess(int severity) {
        return !Severity.isFailure(severity);
    }

    public static boolean atOrAbove(int severity, int threshold) {
        return severity <= threshold;
    }
}

