/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.util;

import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    public static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String emptyIfNull(String s) {
        return s != null ? s : EMPTY_STRING;
    }

    public static String replaceIfNull(String s, String defaultValue) {
        return !StringUtil.isNullOrEmpty(s) ? s : defaultValue;
    }

    public static String nullIfEmpty(String s) {
        if (s != null && s.length() == 0) {
            s = null;
        }
        return s;
    }

    public static String nullIfEmptyTrim(String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNullOrEmptyTrim(String s) {
        if (s == null) {
            return true;
        }
        return (s = s.trim()).length() == 0;
    }

    public static String replaceSubstr(String str, String oldsubstr, String newsubstr) {
        int substrPos = 0;
        int startPos = 0;
        StringBuffer strBuf = new StringBuffer();
        while ((substrPos = str.indexOf(oldsubstr, startPos)) > -1) {
            strBuf.append(str.substring(startPos, substrPos));
            strBuf.append(newsubstr);
            startPos = substrPos + oldsubstr.length();
        }
        strBuf.append(str.substring(startPos));
        return strBuf.toString();
    }

    public static String[] split(String s, String sToken) {
        int iEnd;
        int iTokenLength = sToken.length();
        if (sToken == null || iTokenLength == 0) {
            return new String[]{s};
        }
        int iCount = 0;
        int iBegin = 0;
        while ((iEnd = s.indexOf(sToken, iBegin)) != -1) {
            ++iCount;
            iBegin = iEnd + iTokenLength;
        }
        String[] result = new String[++iCount];
        iCount = 0;
        iBegin = 0;
        while ((iEnd = s.indexOf(sToken, iBegin)) != -1) {
            result[iCount] = s.substring(iBegin, iEnd);
            ++iCount;
            iBegin = iEnd + iTokenLength;
        }
        iEnd = s.length();
        result[iCount] = s.substring(iBegin, iEnd);
        return result;
    }

    public static String replaceJavaLiteral(String s) {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\'': 
                case '\\': {
                    ++newLength;
                }
            }
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block12: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block12;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block12;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block12;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String OnEmptyUseOther(String value, String other) {
        if (StringUtil.isNullOrEmptyTrim(value)) {
            return other;
        }
        return value.trim();
    }

    public static String stringPaddingBefore(String stringValue, String paddingChar, int paddingLength) {
        StringBuffer buffer = new StringBuffer(128);
        int length = stringValue.length();
        for (int i = 0; i < paddingLength - length; ++i) {
            buffer.append(paddingChar);
        }
        buffer.append(stringValue);
        return buffer.toString();
    }

    public static String stringPaddingAfter(String stringValue, String paddingChar, int paddingLength) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(stringValue);
        int length = stringValue.length();
        for (int i = 0; i < paddingLength - length; ++i) {
            buffer.append(paddingChar);
        }
        return buffer.toString();
    }

    public static String[] parseString(String tokenString, String separators) {
        int i1;
        char[] tokenStringChars = tokenString.toCharArray();
        int len = tokenStringChars.length;
        ArrayList<String> tokens = new ArrayList<String>(len / 3 + 1);
        if (separators == null || separators.length() == 0) {
            if (tokenString.length() > 0) {
                tokens.add(tokenString);
            }
            String[] tokenArray = new String[tokens.size()];
            tokens.toArray(tokenArray);
            return tokenArray;
        }
        if (separators.length() == 1) {
            char separatorChar = separators.charAt(0);
            for (i1 = 0; i1 < len && tokenStringChars[i1] == separatorChar; ++i1) {
            }
            while (i1 < len) {
                int i2 = tokenString.indexOf(separatorChar, i1);
                if (i2 < 0) {
                    tokens.add(tokenString.substring(i1));
                    break;
                }
                tokens.add(tokenString.substring(i1, i2));
                for (i1 = i2 + 1; i1 < len && tokenStringChars[i1] == separatorChar; ++i1) {
                }
            }
        } else {
            for (i1 = 0; i1 < len && separators.indexOf(tokenStringChars[i1]) >= 0; ++i1) {
            }
            while (i1 < len) {
                int i2;
                for (i2 = i1; i2 < len && separators.indexOf(tokenStringChars[i2]) < 0; ++i2) {
                }
                tokens.add(tokenString.substring(i1, i2));
                for (i1 = i2 + 1; i1 < len && separators.indexOf(tokenStringChars[i1]) >= 0; ++i1) {
                }
            }
        }
        String[] tokenArray = new String[tokens.size()];
        if (tokens.size() > 0) {
            tokens.toArray(tokenArray);
        }
        return tokenArray;
    }

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static String stringPreview(String inputString) {
        String tmpString = EMPTY_STRING;
        tmpString = inputString.length() >= 20 ? inputString.substring(0, 19) : inputString.substring(0, inputString.length());
        return tmpString;
    }

    public static String replaceIfNullOrError(String s, String defaultValue) {
        String tmpString = EMPTY_STRING;
        try {
            tmpString = StringUtil.replaceIfNull(s, defaultValue);
        }
        catch (Exception e) {
            tmpString = defaultValue;
        }
        return tmpString;
    }

    public static String stripHTML(String html) {
        if (html == null || html.isEmpty()) {
            return EMPTY_STRING;
        }
        if (html.toLowerCase().contains("<body") && html.toLowerCase().contains("</body>")) {
            int beginIndex = html.toLowerCase().indexOf("<body");
            int endIndex = html.toLowerCase().indexOf("</body>");
            html = html.substring(beginIndex, endIndex += "</body>".length());
        }
        for (String tag : new String[]{"style", "script"}) {
            int tries = 10;
            while (tries-- > 0 && html.toLowerCase().contains("<" + tag)) {
                html = StringUtil.removeHTMLBlock(html, tag);
            }
        }
        html = html.replaceAll("&#8226;", EMPTY_STRING);
        html = html.replaceAll("&bull;", EMPTY_STRING);
        html = html.replaceAll("</?\\w+[^><]*>", " ");
        html = StringEscapeUtils.unescapeHtml((String)html);
        return html;
    }

    public static String removeHTMLBlock(String html, String tag) {
        if (html.toLowerCase().contains("<" + tag) && html.toLowerCase().contains("</" + tag)) {
            int beginIndex = html.toLowerCase().indexOf("<" + tag);
            int endIndex = html.toLowerCase().indexOf("</" + tag);
            html = html.substring(0, beginIndex) + html.substring(endIndex += ("</" + tag + ">").length());
        }
        return html;
    }
}

