/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.opensalt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nfbsoftware.opensalt.model.CFDocument;
import com.nfbsoftware.opensalt.model.CFDocuments;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class OpenSALTClient {
    private static final Log logger = LogFactory.getLog(OpenSALTClient.class);
    private String m_hostDomain;
    private String m_hostScheme;
    private int m_hostPort;

    public OpenSALTClient(String hostDomain, int hostPort, String hostScheme) {
        this.m_hostDomain = hostDomain;
        this.m_hostPort = hostPort;
        this.m_hostScheme = hostScheme;
    }

    public List<CFDocument> getAllCFDocuments() throws Exception {
        List<CFDocument> cfDocumentList = new ArrayList<CFDocument>();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting All CFDocuments");
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments");
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            System.out.println(responseJSON.toString());
            ObjectMapper mapper = new ObjectMapper();
            CFDocuments objectValue = (CFDocuments)mapper.readValue(responseJSON.toString(), CFDocuments.class);
            cfDocumentList = objectValue.getCFDocuments();
        }
        return cfDocumentList;
    }

    public List<CFDocument> getCFDocuments(int limit, int offset, String sort, String orderBy) throws Exception {
        List<CFDocument> cfDocumentList = new ArrayList<CFDocument>();
        sort = StringUtils.defaultIfEmpty((String)sort, (String)"title");
        orderBy = StringUtils.defaultIfEmpty((String)orderBy, (String)"asc");
        limit = limit > 100 ? 100 : limit;
        logger.debug((Object)("Getting CFDocuments:  Limit=" + limit + " Offset=" + offset + " Sort=" + sort + " Order By=" + orderBy));
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments?limit=" + limit + "&offset=" + offset + "&sort=" + sort + "&orderBy=" + orderBy);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            System.out.println(responseJSON.toString());
            ObjectMapper mapper = new ObjectMapper();
            CFDocuments objectValue = (CFDocuments)mapper.readValue(responseJSON.toString(), CFDocuments.class);
            cfDocumentList = objectValue.getCFDocuments();
        }
        return cfDocumentList;
    }

    public CFDocument getCFDocument(String sourceId) throws Exception {
        CFDocument cfDocument = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFDocument " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments/" + sourceId);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            System.out.println(responseJSON.toString());
            ObjectMapper mapper = new ObjectMapper();
            cfDocument = (CFDocument)mapper.readValue(responseJSON.toString(), CFDocument.class);
        }
        return cfDocument;
    }
}

