/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.opensalt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import com.nfbsoftware.opensalt.model.CFAssociation;
import com.nfbsoftware.opensalt.model.CFDocument;
import com.nfbsoftware.opensalt.model.CFItem;
import com.nfbsoftware.opensalt.model.CFItemTypeURI;
import com.nfbsoftware.opensalt.model.CFPackages;
import com.nfbsoftware.opensalt.model.DestinationNodeURI;
import com.nfbsoftware.opensalt.model.Documents;
import com.nfbsoftware.opensalt.model.OriginNodeURI;
import com.nfbsoftware.standards.model.Crosswalk;
import com.nfbsoftware.standards.model.Standard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class OpenSALTClient {
    private static final Log logger = LogFactory.getLog(OpenSALTClient.class);
    private String m_hostDomain;
    private String m_hostScheme;
    private int m_hostPort;

    public OpenSALTClient(String hostDomain, int hostPort, String hostScheme) {
        this.m_hostDomain = hostDomain;
        this.m_hostPort = hostPort;
        this.m_hostScheme = hostScheme;
    }

    public List<CFDocument> getAllCFDocuments() throws Exception {
        List<CFDocument> cfDocumentList = new ArrayList<CFDocument>();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting All CFDocuments");
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments");
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            Documents objectValue = (Documents)mapper.readValue(responseJSON.toString(), Documents.class);
            cfDocumentList = objectValue.getCFDocuments();
        }
        return cfDocumentList;
    }

    public List<CFDocument> getCFDocuments(int limit, int offset, String sort, String orderBy) throws Exception {
        List<CFDocument> cfDocumentList = new ArrayList<CFDocument>();
        sort = StringUtils.defaultIfEmpty((String)sort, (String)"title");
        orderBy = StringUtils.defaultIfEmpty((String)orderBy, (String)"asc");
        limit = limit > 100 ? 100 : limit;
        logger.debug((Object)("Getting CFDocuments:  Limit=" + limit + " Offset=" + offset + " Sort=" + sort + " Order By=" + orderBy));
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments?limit=" + limit + "&offset=" + offset + "&sort=" + sort + "&orderBy=" + orderBy);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            Documents objectValue = (Documents)mapper.readValue(responseJSON.toString(), Documents.class);
            cfDocumentList = objectValue.getCFDocuments();
        }
        return cfDocumentList;
    }

    public CFDocument getCFDocument(String sourceId) throws Exception {
        CFDocument cfDocument = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFDocument " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments/" + sourceId);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            cfDocument = (CFDocument)mapper.readValue(responseJSON.toString(), CFDocument.class);
        }
        return cfDocument;
    }

    public CFPackages getCFPackages(String sourceId) throws Exception {
        CFPackages cfPackages = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFPackages " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFPackages/" + sourceId);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            cfPackages = (CFPackages)mapper.readValue(responseJSON.toString(), CFPackages.class);
        }
        return cfPackages;
    }

    public List<CFItem> getCFPackageItems(String sourceId) throws Exception {
        logger.debug((Object)("Getting getCFPackageItems " + sourceId));
        CFPackages cfPackages = this.getCFPackages(sourceId);
        List<CFItem> cfItems = cfPackages.getCFItems();
        return cfItems;
    }

    public List<CFAssociation> getCFPackageAssociations(String sourceId) throws Exception {
        logger.debug((Object)("Getting getCFPackageAssociations " + sourceId));
        CFPackages cfPackages = this.getCFPackages(sourceId);
        List<CFAssociation> cfAssociations = cfPackages.getCFAssociations();
        return cfAssociations;
    }

    public CFItem getCFItem(String sourceId) throws Exception {
        CFItem cfItem = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting getCFItem " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFItems/" + sourceId);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            cfItem = (CFItem)mapper.readValue(responseJSON.toString(), CFItem.class);
        }
        return cfItem;
    }

    public List<CFAssociation> getCFItemAssociations(String sourceId) throws Exception {
        List<CFAssociation> cfAssociations = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFDocument " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFItemAssociations/" + sourceId);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            CFItem tmpCFItem = (CFItem)mapper.readValue(responseJSON.toString(), CFItem.class);
            cfAssociations = tmpCFItem.getCFAssociations();
        }
        return cfAssociations;
    }

    public Standard getFullHierarchicalStandard(String sourceId) throws Exception {
        Standard standardDocument = null;
        CFDocument tmpCFDocument = this.getCFDocument(sourceId);
        if (tmpCFDocument.getIdentifier() != null) {
            standardDocument = new Standard();
            standardDocument.setId(tmpCFDocument.getIdentifier());
            standardDocument.setDocumentId(tmpCFDocument.getIdentifier());
            standardDocument.setDocumentTitle(StringUtils.stripToEmpty((String)tmpCFDocument.getTitle()));
            standardDocument.setFullStatement(StringUtils.stripToEmpty((String)tmpCFDocument.getTitle()));
            standardDocument.setNotes(StringUtils.stripToEmpty((String)tmpCFDocument.getNotes()));
            standardDocument.setCreator(StringUtils.stripToEmpty((String)tmpCFDocument.getCreator()));
            standardDocument.setAdoptionStatus(StringUtils.stripToEmpty((String)tmpCFDocument.getAdoptionStatus()));
            standardDocument.setLanguage(StringUtils.stripToEmpty((String)tmpCFDocument.getLanguage()));
            HashMap<String, CFItem> cfItemsMap = new HashMap<String, CFItem>();
            CFPackages cfPackages = this.getCFPackages(sourceId);
            List<CFItem> cfItems = cfPackages.getCFItems();
            for (CFItem tmpCFItem : cfItems) {
                cfItemsMap.put(tmpCFItem.getIdentifier(), tmpCFItem);
            }
            ArrayList<Standard> topLevelStandards = new ArrayList<Standard>();
            for (CFItem tmpCFItem : cfItems) {
                boolean isTopLevelItem = false;
                List<CFAssociation> tmpAssociations = cfPackages.getCFAssociations();
                for (CFAssociation tmpCFAssociation : tmpAssociations) {
                    OriginNodeURI tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI();
                    DestinationNodeURI tmpDestinationNodeURI = tmpCFAssociation.getDestinationNodeURI();
                    if (tmpDestinationNodeURI == null || tmpOriginNodeURI == null || !tmpDestinationNodeURI.getIdentifier().equalsIgnoreCase(sourceId) || !tmpOriginNodeURI.getIdentifier().equalsIgnoreCase(tmpCFItem.getIdentifier())) continue;
                    isTopLevelItem = true;
                    break;
                }
                if (!isTopLevelItem) continue;
                Standard topLevelStandard = new Standard();
                topLevelStandard.setId(tmpCFItem.getIdentifier());
                topLevelStandard.setFullStatement(StringUtils.stripToEmpty((String)tmpCFItem.getFullStatement()));
                topLevelStandard.setNotes(StringUtils.stripToEmpty((String)tmpCFItem.getNotes()));
                topLevelStandard.setHumanCodingScheme(StringUtils.stripToEmpty((String)tmpCFItem.getHumanCodingScheme()));
                topLevelStandard.setListEnumeration(StringUtils.stripToEmpty((String)tmpCFItem.getListEnumeration()));
                topLevelStandard.setType(StringUtils.stripToEmpty((String)tmpCFItem.getCFItemType()));
                CFItemTypeURI tmpCFItemTypeURI = tmpCFItem.getCFItemTypeURI();
                if (tmpCFItemTypeURI != null) {
                    topLevelStandard.setTypeId(StringUtils.stripToEmpty((String)tmpCFItemTypeURI.getIdentifier()));
                }
                topLevelStandard.setDocumentId(standardDocument.getId());
                topLevelStandard.setDocumentTitle(standardDocument.getDocumentTitle());
                topLevelStandard.setCreator(standardDocument.getCreator());
                topLevelStandard.setAdoptionStatus(standardDocument.getAdoptionStatus());
                topLevelStandard.setLanguage(standardDocument.getLanguage());
                this.getChildAssociations(standardDocument, cfItemsMap, topLevelStandard);
                topLevelStandards.add(topLevelStandard);
            }
            standardDocument.setStandards(topLevelStandards);
        } else {
            CFItem tempCFItem = this.getCFItem(sourceId);
            if (tempCFItem != null) {
                tmpCFDocument = this.getCFDocument(tempCFItem.getCFDocumentURI().getIdentifier());
                HashMap<String, CFItem> cfItemsMap = new HashMap<String, CFItem>();
                CFPackages cfPackages = this.getCFPackages(tmpCFDocument.getIdentifier());
                List<CFItem> cfItems = cfPackages.getCFItems();
                for (CFItem tmpCFItem : cfItems) {
                    cfItemsMap.put(tmpCFItem.getIdentifier(), tmpCFItem);
                }
                standardDocument = new Standard();
                standardDocument.setId(tempCFItem.getIdentifier());
                standardDocument.setDocumentId(tmpCFDocument.getIdentifier());
                standardDocument.setDocumentTitle(StringUtils.stripToEmpty((String)tmpCFDocument.getTitle()));
                standardDocument.setFullStatement(StringUtils.stripToEmpty((String)tempCFItem.getFullStatement()));
                standardDocument.setNotes(StringUtils.stripToEmpty((String)tempCFItem.getNotes()));
                standardDocument.setCreator(StringUtils.stripToEmpty((String)tmpCFDocument.getCreator()));
                standardDocument.setAdoptionStatus(StringUtils.stripToEmpty((String)tmpCFDocument.getAdoptionStatus()));
                standardDocument.setLanguage(StringUtils.stripToEmpty((String)tmpCFDocument.getLanguage()));
                standardDocument.setHumanCodingScheme(StringUtils.stripToEmpty((String)tempCFItem.getHumanCodingScheme()));
                standardDocument.setListEnumeration(StringUtils.stripToEmpty((String)tempCFItem.getListEnumeration()));
                standardDocument.setType(StringUtils.stripToEmpty((String)tempCFItem.getCFItemType()));
                this.getChildAssociations(standardDocument, cfItemsMap, standardDocument);
            }
        }
        return standardDocument;
    }

    private void getChildAssociations(Standard standardDocument, Map<String, CFItem> cfItemsMap, Standard parentStandard) throws Exception {
        List<CFAssociation> tmpAssociations = this.getCFItemAssociations(parentStandard.getId());
        for (CFAssociation tmpCFAssociation : tmpAssociations) {
            OriginNodeURI tmpOriginNodeURI;
            if (!tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || (tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI()) == null || tmpOriginNodeURI.getIdentifier().equalsIgnoreCase(parentStandard.getId())) continue;
            CFItem childCFItem = cfItemsMap.get(tmpOriginNodeURI.getIdentifier());
            Standard childStandard = new Standard();
            childStandard.setId(childCFItem.getIdentifier());
            childStandard.setParentId(parentStandard.getId());
            childStandard.setFullStatement(StringUtils.stripToEmpty((String)childCFItem.getFullStatement()));
            childStandard.setNotes(StringUtils.stripToEmpty((String)childCFItem.getNotes()));
            childStandard.setHumanCodingScheme(StringUtils.stripToEmpty((String)childCFItem.getHumanCodingScheme()));
            childStandard.setListEnumeration(StringUtils.stripToEmpty((String)childCFItem.getListEnumeration()));
            childStandard.setType(StringUtils.stripToEmpty((String)childCFItem.getCFItemType()));
            CFItemTypeURI childCFItemTypeURI = childCFItem.getCFItemTypeURI();
            if (childCFItemTypeURI != null) {
                childStandard.setTypeId(StringUtils.stripToEmpty((String)childCFItemTypeURI.getIdentifier()));
            }
            childStandard.setDocumentId(standardDocument.getId());
            childStandard.setDocumentTitle(standardDocument.getDocumentTitle());
            childStandard.setCreator(standardDocument.getCreator());
            childStandard.setAdoptionStatus(standardDocument.getAdoptionStatus());
            childStandard.setLanguage(standardDocument.getLanguage());
            this.getChildAssociations(standardDocument, cfItemsMap, childStandard);
            parentStandard.getStandards().add(childStandard);
        }
    }

    public Crosswalk getCFItemCrosswalkByDocumentTitle(String rosettaDocumentTitle, String fromCFItemId, String toCFItemId) throws Exception {
        String rosettaCFDocumentId = "";
        List<CFAssociation> fromCFAssociations = this.getCFItemAssociations(fromCFItemId);
        for (CFAssociation tmpCFAssociation : fromCFAssociations) {
            String associatedItemId = tmpCFAssociation.getDestinationNodeURI().getIdentifier();
            CFItem associatedItem = this.getCFItem(associatedItemId);
            if (!associatedItem.getCFDocumentURI().getTitle().contains(rosettaDocumentTitle)) continue;
            rosettaCFDocumentId = associatedItem.getCFDocumentURI().getIdentifier();
            break;
        }
        if (!StringUtils.isEmpty((String)rosettaCFDocumentId)) {
            return this.getCFItemCrosswalk(rosettaCFDocumentId, fromCFItemId, toCFItemId);
        }
        return null;
    }

    public Crosswalk getCFItemCrosswalk(String rosettaCFDocumentId, String fromCFItemId, String toCFItemId) throws Exception {
        Crosswalk tmpCrosswalk = new Crosswalk();
        CFDocument rosettaDocument = this.getCFDocument(rosettaCFDocumentId);
        tmpCrosswalk.setCfDocumentId(rosettaCFDocumentId);
        tmpCrosswalk.setCfDocument(rosettaDocument);
        CFItem fromCFItem = this.getCFItem(fromCFItemId);
        tmpCrosswalk.setFromCFItemId(fromCFItem.getIdentifier());
        tmpCrosswalk.setFromCFItem(fromCFItem);
        CFItem toCFItem = this.getCFItem(toCFItemId);
        tmpCrosswalk.setToCFItemId(toCFItem.getIdentifier());
        tmpCrosswalk.setToCFItem(toCFItem);
        ArrayList<CFItem> rosettaItemAssociations = new ArrayList<CFItem>();
        List<CFAssociation> fromCFAssociations = this.getCFItemAssociations(fromCFItem.getIdentifier());
        for (CFAssociation tmpCFAssociation : fromCFAssociations) {
            String associatedItemId;
            CFItem associatedItem;
            if (tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || !(associatedItem = this.getCFItem(associatedItemId = tmpCFAssociation.getDestinationNodeURI().getIdentifier())).getCFDocumentURI().getIdentifier().equalsIgnoreCase(rosettaDocument.getIdentifier())) continue;
            rosettaItemAssociations.add(associatedItem);
            tmpCrosswalk.getAssociationTypes().add(tmpCFAssociation.getAssociationType());
            tmpCrosswalk.setFromItemAssociationOfDocument(tmpCFAssociation.getAssociationType());
            break;
        }
        block1: for (CFItem tmpRosettaCFItem : rosettaItemAssociations) {
            List<CFAssociation> toCFAssociations = this.getCFItemAssociations(tmpRosettaCFItem.getIdentifier());
            for (CFAssociation tmpCFAssociation : toCFAssociations) {
                OriginNodeURI tmpOriginNodeURI;
                if (tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || (tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI()) == null || !tmpOriginNodeURI.getIdentifier().equalsIgnoreCase(toCFItem.getIdentifier())) continue;
                tmpCrosswalk.getAssociationTypes().add(tmpCFAssociation.getAssociationType());
                tmpCrosswalk.setDocumentAssociationOfToItem(tmpCFAssociation.getAssociationType());
                continue block1;
            }
        }
        String fromText = fromCFItem.getFullStatement();
        String toText = toCFItem.getFullStatement();
        String semanticComparison = this.generateSemanticComparison(fromText, toText);
        tmpCrosswalk.setSemanticComparison(semanticComparison);
        return tmpCrosswalk;
    }

    public List<Crosswalk> getCFItemCrosswalksByDocumentTitle(String rosettaDocumentTitle, String fromCFItemId, String toCFDocumentId) throws Exception {
        String rosettaCFDocumentId = "";
        List<CFAssociation> fromCFAssociations = this.getCFItemAssociations(fromCFItemId);
        for (CFAssociation tmpCFAssociation : fromCFAssociations) {
            String associatedItemId = tmpCFAssociation.getDestinationNodeURI().getIdentifier();
            CFItem associatedItem = this.getCFItem(associatedItemId);
            if (!associatedItem.getCFDocumentURI().getTitle().contains(rosettaDocumentTitle)) continue;
            rosettaCFDocumentId = associatedItem.getCFDocumentURI().getIdentifier();
            break;
        }
        if (!StringUtils.isEmpty((String)rosettaCFDocumentId)) {
            return this.getCFItemCrosswalks(rosettaCFDocumentId, fromCFItemId, toCFDocumentId);
        }
        return new ArrayList<Crosswalk>();
    }

    public List<Crosswalk> getCFItemCrosswalks(String rosettaCFDocumentId, String fromCFItemId, String toCFDocumentId) throws Exception {
        HashSet<String> toItemIds = new HashSet<String>();
        ArrayList<Crosswalk> tmpCrosswalkList = new ArrayList<Crosswalk>();
        CFDocument rosettaDocument = this.getCFDocument(rosettaCFDocumentId);
        CFItem fromCFItem = this.getCFItem(fromCFItemId);
        ArrayList<CFItem> rosettaItemAssociations = new ArrayList<CFItem>();
        List<CFAssociation> fromCFAssociations = this.getCFItemAssociations(fromCFItem.getIdentifier());
        for (CFAssociation tmpCFAssociation : fromCFAssociations) {
            String associatedItemId;
            CFItem associatedItem;
            if (tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || !(associatedItem = this.getCFItem(associatedItemId = tmpCFAssociation.getDestinationNodeURI().getIdentifier())).getCFDocumentURI().getIdentifier().equalsIgnoreCase(rosettaDocument.getIdentifier())) continue;
            rosettaItemAssociations.add(associatedItem);
            break;
        }
        for (CFItem tmpRosettaCFItem : rosettaItemAssociations) {
            List<CFAssociation> toCFAssociations = this.getCFItemAssociations(tmpRosettaCFItem.getIdentifier());
            for (CFAssociation tmpCFAssociation : toCFAssociations) {
                CFItem originItem;
                OriginNodeURI tmpOriginNodeURI;
                if (tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || (tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI()) == null || !(originItem = this.getCFItem(tmpOriginNodeURI.getIdentifier())).getCFDocumentURI().getIdentifier().equalsIgnoreCase(toCFDocumentId) || toItemIds.contains(originItem.getIdentifier())) continue;
                Crosswalk tmpCrosswalk = new Crosswalk();
                tmpCrosswalk.setCfDocumentId(rosettaCFDocumentId);
                tmpCrosswalk.setCfDocument(rosettaDocument);
                tmpCrosswalk.setFromCFItemId(fromCFItem.getIdentifier());
                tmpCrosswalk.setFromCFItem(fromCFItem);
                tmpCrosswalk.setToCFItemId(originItem.getIdentifier());
                tmpCrosswalk.setToCFItem(originItem);
                tmpCrosswalk.getAssociationTypes().add(tmpCFAssociation.getAssociationType());
                tmpCrosswalk.setDocumentAssociationOfToItem(tmpCFAssociation.getAssociationType());
                String fromText = StringUtils.trimToEmpty((String)fromCFItem.getFullStatement());
                String toText = StringUtils.trimToEmpty((String)originItem.getFullStatement());
                String semanticComparison = this.generateSemanticComparison(fromText, toText);
                tmpCrosswalk.setSemanticComparison(semanticComparison);
                tmpCrosswalkList.add(tmpCrosswalk);
                toItemIds.add(originItem.getIdentifier());
            }
        }
        return tmpCrosswalkList;
    }

    private String generateSemanticComparison(String fromText, String toText) throws DiffException {
        String semanticComparison = "";
        DiffRowGenerator generator = DiffRowGenerator.create().showInlineDiffs(true).mergeOriginalRevised(true).inlineDiffByWord(true).oldTag(f -> f != false ? "<span class=\"openSaltOldTag\">" : "</span>").newTag(f -> f != false ? "<span class=\"openSaltNewTag\">" : "</span>").build();
        List rows = generator.generateDiffRows(Arrays.asList(fromText), Arrays.asList(toText));
        semanticComparison = ((DiffRow)rows.get(0)).getOldLine();
        return semanticComparison;
    }
}

