/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.opensalt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nfbsoftware.pcg.model.PCGCrosswalk;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class CrosswalkClient {
    private static final Log logger = LogFactory.getLog(CrosswalkClient.class);
    private String m_hostDomain;
    private String m_hostScheme;
    private int m_hostPort;
    private String m_authenticationUrl;
    private String m_grantType;
    private String m_scope;
    private String m_clientId;
    private String m_clientSecret;
    private String m_token;

    public CrosswalkClient(String hostDomain, int hostPort, String hostScheme) {
        this.m_hostDomain = hostDomain;
        this.m_hostPort = hostPort;
        this.m_hostScheme = hostScheme;
    }

    public void setCredentials(String authenticationUrl, String clientId, String clientSecret, String grantType, String scope) throws Exception {
        this.m_authenticationUrl = authenticationUrl;
        this.m_clientId = clientId;
        this.m_clientSecret = clientSecret;
        this.m_grantType = grantType;
        this.m_scope = scope;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost postRequest = new HttpPost(this.m_authenticationUrl);
        String usernamePassword = this.m_clientId + ":" + this.m_clientSecret;
        String encodedString = Base64.getEncoder().encodeToString(usernamePassword.getBytes());
        postRequest.setHeader("Authorization", "Basic " + encodedString);
        postRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        postParameters.add(new BasicNameValuePair("grant_type", this.m_grantType));
        postParameters.add(new BasicNameValuePair("scope", this.m_scope));
        postRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
        HttpResponse saltyResponse = httpClient.execute((HttpUriRequest)postRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            this.m_token = StringUtils.stripToEmpty((String)responseJSON.getString("access_token"));
        }
    }

    public void refreshAccessToken() throws Exception {
        if (this.m_token != null) {
            this.setCredentials(this.m_authenticationUrl, this.m_clientId, this.m_clientSecret, this.m_grantType, this.m_scope);
        }
    }

    public PCGCrosswalk crosswalkByIdentifier(String identifier, String target) throws Exception {
        HttpResponse saltyResponse;
        HttpEntity entity;
        PCGCrosswalk tmpPCGCrosswalk = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost targetHost = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting crosswalk by identifier");
        HttpGet getRequest = new HttpGet("/api/v1/crosswalk/by-identifier/" + identifier + "/" + target);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        if ((entity = (saltyResponse = httpClient.execute(targetHost, (HttpRequest)getRequest)).getEntity()) != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            logger.debug((Object)("Crosswalk/by-identifier Response (" + identifier + " to " + target + "): " + responseJSON.toString()));
            ObjectMapper mapper = new ObjectMapper();
            tmpPCGCrosswalk = (PCGCrosswalk)mapper.readValue(responseJSON.toString(), PCGCrosswalk.class);
        }
        return tmpPCGCrosswalk;
    }

    public PCGCrosswalk crosswalkByHumanCodingScheme(String source, String hcs, String target) throws Exception {
        HttpResponse saltyResponse;
        HttpEntity entity;
        PCGCrosswalk tmpPCGCrosswalk = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost targetHost = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting crosswalk by human coding scheme");
        HttpGet getRequest = new HttpGet("/api/v1/crosswalk/by-hcs/" + source + "/" + hcs + "/" + target);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        if ((entity = (saltyResponse = httpClient.execute(targetHost, (HttpRequest)getRequest)).getEntity()) != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            logger.debug((Object)("Crosswalk/by-hcs Response (" + source + " -  " + hcs + " - " + target + "): " + responseJSON.toString()));
            ObjectMapper mapper = new ObjectMapper();
            tmpPCGCrosswalk = (PCGCrosswalk)mapper.readValue(responseJSON.toString(), PCGCrosswalk.class);
        }
        return tmpPCGCrosswalk;
    }
}

