/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.opensalt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nfbsoftware.opensalt.model.CFAssociation;
import com.nfbsoftware.opensalt.model.CFDocument;
import com.nfbsoftware.opensalt.model.CFItem;
import com.nfbsoftware.opensalt.model.CFItemTypeURI;
import com.nfbsoftware.opensalt.model.CFPackages;
import com.nfbsoftware.opensalt.model.Documents;
import com.nfbsoftware.opensalt.model.OriginNodeURI;
import com.nfbsoftware.standards.model.Standard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class OpenSALTClient {
    private static final Log logger = LogFactory.getLog(OpenSALTClient.class);
    private String m_hostDomain;
    private String m_hostScheme;
    private int m_hostPort;

    public OpenSALTClient(String hostDomain, int hostPort, String hostScheme) {
        this.m_hostDomain = hostDomain;
        this.m_hostPort = hostPort;
        this.m_hostScheme = hostScheme;
    }

    public List<CFDocument> getAllCFDocuments() throws Exception {
        List<CFDocument> cfDocumentList = new ArrayList<CFDocument>();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting All CFDocuments");
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments");
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            Documents objectValue = (Documents)mapper.readValue(responseJSON.toString(), Documents.class);
            cfDocumentList = objectValue.getCFDocuments();
        }
        return cfDocumentList;
    }

    public List<CFDocument> getCFDocuments(int limit, int offset, String sort, String orderBy) throws Exception {
        List<CFDocument> cfDocumentList = new ArrayList<CFDocument>();
        sort = StringUtils.defaultIfEmpty((String)sort, (String)"title");
        orderBy = StringUtils.defaultIfEmpty((String)orderBy, (String)"asc");
        limit = limit > 100 ? 100 : limit;
        logger.debug((Object)("Getting CFDocuments:  Limit=" + limit + " Offset=" + offset + " Sort=" + sort + " Order By=" + orderBy));
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments?limit=" + limit + "&offset=" + offset + "&sort=" + sort + "&orderBy=" + orderBy);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            Documents objectValue = (Documents)mapper.readValue(responseJSON.toString(), Documents.class);
            cfDocumentList = objectValue.getCFDocuments();
        }
        return cfDocumentList;
    }

    public CFDocument getCFDocument(String sourceId) throws Exception {
        CFDocument cfDocument = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFDocument " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments/" + sourceId);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            cfDocument = (CFDocument)mapper.readValue(responseJSON.toString(), CFDocument.class);
        }
        return cfDocument;
    }

    public List<CFItem> getCFPackages(String sourceId) throws Exception {
        List<CFItem> cfItems = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFPackages " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFPackages/" + sourceId);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            CFPackages tmpCFPackages = (CFPackages)mapper.readValue(responseJSON.toString(), CFPackages.class);
            cfItems = tmpCFPackages.getCFItems();
        }
        return cfItems;
    }

    public CFItem getCFItem(String sourceId) throws Exception {
        CFItem cfItem = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFDocument " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFItems/" + sourceId);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            cfItem = (CFItem)mapper.readValue(responseJSON.toString(), CFItem.class);
        }
        return cfItem;
    }

    public List<CFAssociation> getCFItemAssociations(String sourceId) throws Exception {
        List<CFAssociation> cfAssociations = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFDocument " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFItemAssociations/" + sourceId);
        HttpResponse saltyResponse = httpClient.execute(target, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            CFItem tmpCFItem = (CFItem)mapper.readValue(responseJSON.toString(), CFItem.class);
            cfAssociations = tmpCFItem.getCFAssociations();
        }
        return cfAssociations;
    }

    public Standard getFullHierarchicalStandard(String documentSourceId) throws Exception {
        Standard standardDocument = null;
        CFDocument tmpCFDocument = this.getCFDocument(documentSourceId);
        if (tmpCFDocument != null) {
            standardDocument = new Standard();
            standardDocument.setId(tmpCFDocument.getIdentifier());
            standardDocument.setDocumentTitle(StringUtils.stripToEmpty((String)tmpCFDocument.getTitle()));
            standardDocument.setFullStatement(StringUtils.stripToEmpty((String)tmpCFDocument.getTitle()));
            standardDocument.setNotes(StringUtils.stripToEmpty((String)tmpCFDocument.getNotes()));
            standardDocument.setCreator(StringUtils.stripToEmpty((String)tmpCFDocument.getCreator()));
            standardDocument.setAdoptionStatus(StringUtils.stripToEmpty((String)tmpCFDocument.getAdoptionStatus()));
            standardDocument.setLanguage(StringUtils.stripToEmpty((String)tmpCFDocument.getLanguage()));
            HashMap<String, CFItem> cfItemsMap = new HashMap<String, CFItem>();
            List<CFItem> cfItems = this.getCFPackages(documentSourceId);
            for (CFItem tmpCFItem : cfItems) {
                cfItemsMap.put(tmpCFItem.getIdentifier(), tmpCFItem);
            }
            ArrayList<Standard> topLevelStandards = new ArrayList<Standard>();
            for (CFItem tmpCFItem : cfItems) {
                if (tmpCFItem.getCFItemType() != null) continue;
                Standard topLevelStandard = new Standard();
                topLevelStandard.setId(tmpCFItem.getIdentifier());
                topLevelStandard.setFullStatement(StringUtils.stripToEmpty((String)tmpCFItem.getFullStatement()));
                topLevelStandard.setNotes(StringUtils.stripToEmpty((String)tmpCFItem.getNotes()));
                topLevelStandard.setHumanCodingScheme(StringUtils.stripToEmpty((String)tmpCFItem.getHumanCodingScheme()));
                topLevelStandard.setListEnumeration(StringUtils.stripToEmpty((String)tmpCFItem.getListEnumeration()));
                topLevelStandard.setType(StringUtils.stripToEmpty((String)tmpCFItem.getCFItemType()));
                CFItemTypeURI tmpCFItemTypeURI = tmpCFItem.getCFItemTypeURI();
                if (tmpCFItemTypeURI != null) {
                    topLevelStandard.setTypeId(StringUtils.stripToEmpty((String)tmpCFItemTypeURI.getIdentifier()));
                }
                topLevelStandard.setDocumentId(standardDocument.getId());
                topLevelStandard.setDocumentTitle(standardDocument.getDocumentTitle());
                topLevelStandard.setCreator(standardDocument.getCreator());
                topLevelStandard.setAdoptionStatus(standardDocument.getAdoptionStatus());
                topLevelStandard.setLanguage(standardDocument.getLanguage());
                this.getChildAssociations(standardDocument, cfItemsMap, topLevelStandard);
                topLevelStandards.add(topLevelStandard);
            }
            standardDocument.setStandards(topLevelStandards);
        }
        return standardDocument;
    }

    private void getChildAssociations(Standard standardDocument, Map<String, CFItem> cfItemsMap, Standard parentStandard) throws Exception {
        List<CFAssociation> tmpAssociations = this.getCFItemAssociations(parentStandard.getId());
        for (CFAssociation tmpCFAssociation : tmpAssociations) {
            OriginNodeURI tmpOriginNodeURI;
            if (!tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || (tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI()) == null || tmpOriginNodeURI.getIdentifier().equalsIgnoreCase(parentStandard.getId())) continue;
            CFItem childCFItem = cfItemsMap.get(tmpOriginNodeURI.getIdentifier());
            Standard childStandard = new Standard();
            childStandard.setId(childCFItem.getIdentifier());
            childStandard.setParentId(parentStandard.getId());
            childStandard.setFullStatement(StringUtils.stripToEmpty((String)childCFItem.getFullStatement()));
            childStandard.setNotes(StringUtils.stripToEmpty((String)childCFItem.getNotes()));
            childStandard.setHumanCodingScheme(StringUtils.stripToEmpty((String)childCFItem.getHumanCodingScheme()));
            childStandard.setListEnumeration(StringUtils.stripToEmpty((String)childCFItem.getListEnumeration()));
            childStandard.setType(StringUtils.stripToEmpty((String)childCFItem.getCFItemType()));
            CFItemTypeURI childCFItemTypeURI = childCFItem.getCFItemTypeURI();
            if (childCFItemTypeURI != null) {
                childStandard.setTypeId(StringUtils.stripToEmpty((String)childCFItemTypeURI.getIdentifier()));
            }
            childStandard.setDocumentId(standardDocument.getId());
            childStandard.setDocumentTitle(standardDocument.getDocumentTitle());
            childStandard.setCreator(standardDocument.getCreator());
            childStandard.setAdoptionStatus(standardDocument.getAdoptionStatus());
            childStandard.setLanguage(standardDocument.getLanguage());
            this.getChildAssociations(standardDocument, cfItemsMap, childStandard);
            parentStandard.getStandards().add(childStandard);
        }
    }
}

