/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.opensalt;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nfbsoftware.pcg.model.PCGCrosswalk;
import com.nfbsoftware.standards.model.Standard;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class CrosswalkClient {
    private static final Log logger = LogFactory.getLog(CrosswalkClient.class);
    private String m_hostDomain;
    private String m_hostScheme;
    private int m_hostPort;
    private String m_authenticationUrl;
    private String m_grantType;
    private String m_scope;
    private String m_clientId;
    private String m_clientSecret;
    private String m_token;

    public CrosswalkClient(String hostDomain, int hostPort, String hostScheme) {
        this.m_hostDomain = hostDomain;
        this.m_hostPort = hostPort;
        this.m_hostScheme = hostScheme;
    }

    public void setCredentials(String authenticationUrl, String clientId, String clientSecret, String grantType, String scope) throws Exception {
        this.m_authenticationUrl = authenticationUrl;
        this.m_clientId = clientId;
        this.m_clientSecret = clientSecret;
        this.m_grantType = grantType;
        this.m_scope = scope;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost postRequest = new HttpPost(this.m_authenticationUrl);
        String usernamePassword = this.m_clientId + ":" + this.m_clientSecret;
        String encodedString = Base64.getEncoder().encodeToString(usernamePassword.getBytes());
        postRequest.setHeader("Authorization", "Basic " + encodedString);
        postRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        postParameters.add(new BasicNameValuePair("grant_type", this.m_grantType));
        postParameters.add(new BasicNameValuePair("scope", this.m_scope));
        postRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
        HttpResponse saltyResponse = httpClient.execute((HttpUriRequest)postRequest);
        HttpEntity entity = saltyResponse.getEntity();
        System.out.println(saltyResponse.getStatusLine().getStatusCode());
        if (saltyResponse.getStatusLine().getStatusCode() == 200) {
            if (entity != null) {
                String responseString = EntityUtils.toString((HttpEntity)entity);
                JSONObject responseJSON = new JSONObject(responseString);
                this.m_token = StringUtils.stripToEmpty((String)responseJSON.getString("access_token"));
            }
        } else {
            String errorMessage = "Unable to acquire an authentication token for crosswalk: " + saltyResponse.getStatusLine().getStatusCode() + " - " + saltyResponse.getStatusLine().getReasonPhrase();
            System.out.println(errorMessage);
            throw new Exception(errorMessage);
        }
    }

    public void refreshAccessToken() throws Exception {
        if (this.m_token != null) {
            this.setCredentials(this.m_authenticationUrl, this.m_clientId, this.m_clientSecret, this.m_grantType, this.m_scope);
        }
    }

    public PCGCrosswalk crosswalkByIdentifier(String identifier, String target) throws Exception {
        PCGCrosswalk tmpPCGCrosswalk = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost targetHost = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting crosswalk by identifier");
        HttpGet getRequest = new HttpGet("/api/v1/crosswalk/by-identifier/" + identifier + "/" + target);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        HttpResponse saltyResponse = httpClient.execute(targetHost, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (saltyResponse.getStatusLine().getStatusCode() == 200 && entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            logger.debug((Object)("Crosswalk/by-identifier Response (" + identifier + " to " + target + "): " + responseJSON.toString()));
            ObjectMapper mapper = new ObjectMapper();
            tmpPCGCrosswalk = (PCGCrosswalk)mapper.readValue(responseJSON.toString(), PCGCrosswalk.class);
        }
        return tmpPCGCrosswalk;
    }

    public PCGCrosswalk crosswalkByHumanCodingScheme(String source, String hcs, String target) throws Exception {
        PCGCrosswalk tmpPCGCrosswalk = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost targetHost = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting crosswalk by human coding scheme");
        HttpGet getRequest = new HttpGet("/api/v1/crosswalk/by-hcs/" + source + "/" + hcs + "/" + target);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        HttpResponse saltyResponse = httpClient.execute(targetHost, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (saltyResponse.getStatusLine().getStatusCode() == 200 && entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            logger.debug((Object)("Crosswalk/by-hcs Response (" + source + " -  " + hcs + " - " + target + "): " + responseJSON.toString()));
            ObjectMapper mapper = new ObjectMapper();
            tmpPCGCrosswalk = (PCGCrosswalk)mapper.readValue(responseJSON.toString(), PCGCrosswalk.class);
        }
        return tmpPCGCrosswalk;
    }

    public Map<String, PCGCrosswalk> crosswalkByIdentifiers(List<String> identifiers, String target) throws Exception {
        HashMap<String, PCGCrosswalk> tmpPCGCrosswalks = new HashMap<String, PCGCrosswalk>();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost targetHost = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting crosswalk by identifiers");
        HttpPost postRequest = new HttpPost("/api/v1/crosswalk/to-framework/" + target);
        if (this.m_token != null) {
            postRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        JSONObject postBodyJSON = new JSONObject();
        postBodyJSON.append("identifiers", identifiers);
        String tmpBody = StringUtils.replace((String)postBodyJSON.toString(), (String)"[[", (String)"[");
        tmpBody = StringUtils.replace((String)tmpBody, (String)"]]", (String)"]");
        ByteArrayEntity postBody = new ByteArrayEntity(tmpBody.getBytes("UTF-8"));
        postRequest.setEntity((HttpEntity)postBody);
        HttpResponse saltyResponse = httpClient.execute(targetHost, (HttpRequest)postRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (saltyResponse.getStatusLine().getStatusCode() == 200 && entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            logger.debug((Object)("Crosswalk/to-framework Response (" + target + "): " + responseJSON.toString()));
            Set identifierKeys = null;
            try {
                identifierKeys = responseJSON.keySet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ObjectMapper mapper = new ObjectMapper();
            for (String key : identifierKeys) {
                PCGCrosswalk tmpPCGCrosswalk = (PCGCrosswalk)mapper.readValue(responseJSON.get(key).toString(), PCGCrosswalk.class);
                if (tmpPCGCrosswalk == null) continue;
                tmpPCGCrosswalks.put(key, tmpPCGCrosswalk);
            }
        }
        return tmpPCGCrosswalks;
    }

    public Standard getEvotextHierarchyFramework(String sourceId) throws IOException, ClientProtocolException, JsonParseException, JsonMappingException {
        Standard tmpStandardDocument = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost targetHost = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting EvotextHierarchy Framework");
        HttpGet getRequest = new HttpGet("/api/v1/framework/evotext-hierarchy/" + sourceId);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        HttpResponse saltyResponse = httpClient.execute(targetHost, (HttpRequest)getRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (saltyResponse.getStatusLine().getStatusCode() == 200 && entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            logger.debug((Object)("evotext-hierarchy/{identifier} Response (" + sourceId + ")"));
            ObjectMapper mapper = new ObjectMapper();
            Standard tmpStandard = (Standard)mapper.readValue(responseString, Standard.class);
            if (tmpStandard != null) {
                tmpStandardDocument = tmpStandard;
            }
        }
        return tmpStandardDocument;
    }
}

