/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.support;

import com.objectsql.exception.ORMException;
import com.objectsql.query.QueryUtils;
import com.objectsql.support.CaseColumn;
import com.objectsql.support.Column;
import com.objectsql.support.LambdaQuery;
import com.objectsql.utils.ORMUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Columns
implements Serializable {
    private List<Column> columns = new ArrayList<Column>();
    private String alias;
    private String[] names;
    private String[] asNames;
    private String[] fieldNames;
    private String asNamePrefix;

    public Columns() {
    }

    public String getAsNamePrefix() {
        return this.asNamePrefix;
    }

    public void setAsNamePrefix(String asNamePrefix) {
        this.asNamePrefix = asNamePrefix;
    }

    public Columns(String alias) {
        this.alias = alias;
    }

    public Columns(String alias, String ... names) {
        this.alias = alias;
        this.names = names;
    }

    public Columns names(String ... names) {
        this.names = names;
        return this;
    }

    public <T, R> Columns names(LambdaQuery<T, R> ... lambdaQueries) {
        this.names = QueryUtils.getColumns(lambdaQueries);
        return this;
    }

    @Deprecated
    public Columns asNames(String ... asNames) {
        this.asNames = asNames;
        return this;
    }

    public Columns as(String ... asNames) {
        this.asNames = asNames;
        return this;
    }

    @Deprecated
    public <T, R> Columns asNames(LambdaQuery<T, R> ... lambdaQueries) {
        return this.as(lambdaQueries);
    }

    public <T, R> Columns as(LambdaQuery<T, R> ... lambdaQueries) {
        if (lambdaQueries != null) {
            String[] names = new String[lambdaQueries.length];
            for (int i = 0; i < names.length; ++i) {
                String column = QueryUtils.getColumn(lambdaQueries[i]);
                names[i] = !ORMUtils.isEmpty(column) ? column : QueryUtils.getField(lambdaQueries[i]);
            }
            this.asNames = names;
        }
        return this;
    }

    @Deprecated
    public Columns asNamePrefix(String asNamePrefix) {
        this.asNamePrefix = asNamePrefix;
        return this;
    }

    public Columns asPrefix(String asNamePrefix) {
        this.asNamePrefix = asNamePrefix;
        return this;
    }

    public Columns fieldNames(String ... fieldNames) {
        this.fieldNames = fieldNames;
        return this;
    }

    public Columns c(Column column) {
        if (column != null) {
            if (ORMUtils.isEmpty(column.getAlias()) && !ORMUtils.isEmpty(this.alias)) {
                column.setAlias(this.alias);
            }
            this.columns.add(column);
        }
        return this;
    }

    @Deprecated
    public List<Column> getColumnList() {
        return this.buildColumns();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Column> buildColumns() {
        ArrayList<Column> columnList = new ArrayList<Column>();
        if (this.names != null && this.alias != null) {
            String prefix;
            String string = prefix = this.asNamePrefix == null ? "" : this.asNamePrefix;
            if (this.asNames == null) {
                if (this.fieldNames == null) {
                    for (String name : this.names) {
                        if (ORMUtils.isEmpty(prefix)) {
                            columnList.add(new Column(this.alias, name));
                            continue;
                        }
                        columnList.add(new Column(this.alias, name).as(prefix + name));
                    }
                } else {
                    if (this.names.length != this.fieldNames.length) throw new ORMException("TABLE_QUERY_NAMES_AS_NOT_EQUAL, names length: " + this.names.length + ", fieldNames length : " + this.fieldNames.length);
                    for (int i = 0; i < this.names.length; ++i) {
                        if (ORMUtils.isEmpty(prefix)) {
                            columnList.add(new Column(this.alias, this.names[i]).fieldName(this.fieldNames[i]));
                            continue;
                        }
                        columnList.add(new Column(this.alias, this.names[i]).as(prefix + this.names[i]).fieldName(this.fieldNames[i]));
                    }
                }
            } else {
                if (this.names.length != this.asNames.length) throw new ORMException("TABLE_QUERY_NAMES_AS_NOT_EQUAL, names length: " + this.names.length + ", asNames length : " + this.asNames.length);
                if (this.fieldNames != null) {
                    if (this.names.length != this.fieldNames.length) throw new ORMException("TABLE_QUERY_NAMES_AS_NOT_EQUAL, names length: " + this.names.length + ", fieldNames length : " + this.fieldNames.length);
                    for (int i = 0; i < this.names.length; ++i) {
                        columnList.add(new Column(this.alias, this.names[i], prefix + this.asNames[i]).fieldName(this.fieldNames[i]));
                    }
                } else {
                    for (int i = 0; i < this.names.length; ++i) {
                        columnList.add(new Column(this.alias, this.names[i], prefix + this.asNames[i]));
                    }
                }
            }
        }
        for (Column col : this.columns) {
            Column column;
            if (col instanceof CaseColumn) {
                column = new CaseColumn(col.getFunction(), col.getAlias(), col.getName(), col.getAsName());
                column.setFieldName(col.getFieldName());
                column.setFormat(col.getFormat());
                column.setOperatorInFunction(col.getOperatorInFunction());
                column.setQuery(col.getQuery());
                column.setType(col.getType());
                column.setValue(col.getValue());
                CaseColumn caseColumn = (CaseColumn)col;
                ((CaseColumn)column).setConditions(caseColumn.getConditions());
                ((CaseColumn)column).setElseValue(caseColumn.getElseValue());
                columnList.add(column);
                continue;
            }
            column = new Column(col.getFunction(), col.getAlias(), col.getName(), col.getAsName());
            column.setFieldName(col.getFieldName());
            column.setFormat(col.getFormat());
            column.setOperatorInFunction(col.getOperatorInFunction());
            column.setQuery(col.getQuery());
            column.setType(col.getType());
            column.setValue(col.getValue());
            if (!ORMUtils.isEmpty(this.asNamePrefix)) {
                if (ORMUtils.isEmpty(column.getAsName())) {
                    column.setAsName(this.asNamePrefix + column.getName());
                }
                if (!ORMUtils.isEmpty(column.getFieldName())) {
                    column.setFieldName(QueryUtils.displayName(this.asNamePrefix) + column.getFieldName().substring(0, 1).toUpperCase(Locale.ROOT) + column.getFieldName().substring(1));
                }
            }
            columnList.add(column);
        }
        return columnList;
    }
}

