/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.executors.AbstractIdentifieredExpressionListedExpression;
import com.scriptbasic.executors.rightvalues.BasicArrayValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.HierarchicalVariableMap;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.utility.RightValueUtility;

public class ArrayElementAccess
extends AbstractIdentifieredExpressionListedExpression {
    @Override
    public RightValue evaluate(ExtendedInterpreter interpreter) throws ExecutionException {
        HierarchicalVariableMap variableMap = interpreter.getVariables();
        RightValue value = variableMap.getVariableValue(this.getVariableName());
        value = interpreter.getHook().variableRead(this.getVariableName(), value);
        for (Expression expression : this.getExpressionList()) {
            if (!(value instanceof BasicArrayValue)) continue;
            BasicArrayValue arrayVar = (BasicArrayValue)value;
            Integer index = RightValueUtility.convert2Integer(expression.evaluate(interpreter));
            Object object = arrayVar.get(index);
            if (object instanceof RightValue) {
                value = (RightValue)object;
                continue;
            }
            value = new BasicJavaObjectValue(object);
            arrayVar.set(index, value);
        }
        return value;
    }
}

