/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.executors.AbstractIdentifieredExpressionListedExpression;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.LeftValue;
import com.scriptbasic.interfaces.LeftValueList;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.ReflectionUtility;
import com.scriptbasic.utility.RightValueUtility;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

public class FunctionCall
extends AbstractIdentifieredExpressionListedExpression {
    private boolean commandNeedLookup = true;
    private CommandSub commandSub = null;

    private RightValue callBasicFunction(ExtendedInterpreter interpreter) throws ExecutionException {
        RightValue result = null;
        RightValue[] argumentValues = FunctionCall.evaluateArguments(this.getExpressionList(), interpreter);
        interpreter.push();
        LeftValueList arguments = this.commandSub.getArguments();
        FunctionCall.registerLocalVariablesWithValues(arguments, argumentValues, interpreter);
        interpreter.disableHook();
        interpreter.setReturnValue(null);
        interpreter.enableHook();
        interpreter.getHook().beforeSubroutineCall(this.getVariableName(), arguments, argumentValues);
        interpreter.execute(this.commandSub.getNextCommand());
        result = interpreter.getReturnValue();
        interpreter.pop();
        return result;
    }

    private RightValue callJavaFunction(ExtendedInterpreter interpreter) throws ExecutionException {
        RightValue result = null;
        String functionName = this.getVariableName();
        List<RightValue> args = ExpressionUtility.evaluateExpressionList(interpreter, this.getExpressionList());
        Method method = interpreter.getJavaMethod(null, functionName);
        if (method != null) {
            Object methodResult = null;
            methodResult = ReflectionUtility.invoke(functionName, interpreter, method, null, args);
            result = RightValueUtility.createRightValue(methodResult);
        }
        return result;
    }

    private void lookUpCommandSub(ExtendedInterpreter interpreter) {
        if (this.commandNeedLookup) {
            this.commandNeedLookup = false;
            this.commandSub = interpreter.getSubroutine(this.getVariableName());
        }
    }

    private static RightValue[] evaluateArguments(ExpressionList argumentList, ExtendedInterpreter interpreter) throws ExecutionException {
        RightValue[] argumentValues;
        if (argumentList == null) {
            argumentValues = null;
        } else {
            Iterator expressionIterator = argumentList.iterator();
            argumentValues = new RightValue[argumentList.size()];
            for (int i = 0; i < argumentValues.length; ++i) {
                argumentValues[i] = ((Expression)expressionIterator.next()).evaluate(interpreter);
            }
        }
        return argumentValues;
    }

    private static void registerLocalVariablesWithValues(LeftValueList arguments, RightValue[] argumentValues, ExtendedInterpreter interpreter) throws ExecutionException {
        if (arguments != null) {
            Iterator argumentIterator = arguments.iterator();
            for (int i = 0; i < argumentValues.length; ++i) {
                LeftValue argument = (LeftValue)argumentIterator.next();
                if (!(argument instanceof BasicLeftValue)) {
                    throw new BasicRuntimeException("subroutine formal argument is erroneous");
                }
                String name = ((BasicLeftValue)argument).getIdentifier();
                interpreter.getVariables().registerLocalVariable(name);
                interpreter.setVariable(name, argumentValues[i]);
            }
        }
    }

    @Override
    public RightValue evaluate(ExtendedInterpreter interpreter) throws ExecutionException {
        this.lookUpCommandSub(interpreter);
        RightValue result = null;
        result = this.commandSub == null ? this.callJavaFunction(interpreter) : this.callBasicFunction(interpreter);
        return result;
    }
}

