/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.executors.rightvalues.BasicArrayValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.UtilityUtility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ReflectionUtility {
    private ReflectionUtility() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    public static void setField(Object object, String fieldName, Object value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ReflectionUtility.setField(null, object, fieldName, value);
    }

    public static Object invoke(String symbolicName, ExtendedInterpreter interpreter, Method method, Object object, List<RightValue> args) throws BasicRuntimeException {
        Object javaCallResult;
        interpreter.getHook().beforeCallJavaFunction(method);
        try {
            Object[] argArray = ExpressionUtility.getObjectArray(args, method, interpreter);
            javaCallResult = method.invoke(object, argArray);
            if (javaCallResult instanceof BasicArrayValue) {
                ((BasicArrayValue)javaCallResult).setInterpreter(interpreter);
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException || e instanceof IllegalArgumentException || e instanceof IllegalAccessException) {
                throw new BasicRuntimeException("Can not invoke method " + symbolicName, e);
            }
            throw new BasicRuntimeException("Invoking method '" + symbolicName + "' throws exception:", e);
        }
        Object result = interpreter.getHook().afterCallJavaFunction(method, javaCallResult);
        return result;
    }

    public static void setField(Class<?> klass, String fieldName, Object value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ReflectionUtility.setField(klass, null, fieldName, value);
    }

    private static void setField(Class<?> klass, Object object, String fieldName, Object value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field;
        Class<?> kLass = klass;
        if (kLass == null) {
            kLass = object.getClass();
        }
        try {
            field = kLass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e0) {
            try {
                field = kLass.getField(fieldName);
            }
            catch (NoSuchFieldException e1) {
                field = null;
            }
        }
        if (field == null) {
            throw new NoSuchFieldException(fieldName + " in " + object.getClass());
        }
        field.setAccessible(true);
        field.set(object, value);
    }
}

