/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.operators;

import com.scriptbasic.executors.operators.AbstractBinaryFullCircuitNumericOperator;
import com.scriptbasic.executors.rightvalues.BasicDoubleValue;
import com.scriptbasic.executors.rightvalues.BasicLongValue;
import com.scriptbasic.spi.RightValue;

public class ModuloOperator
extends AbstractBinaryFullCircuitNumericOperator<Number> {
    @Override
    protected RightValue operateOnDoubleDouble(Double a, Double b) {
        return new BasicDoubleValue(a % b);
    }

    @Override
    protected RightValue operateOnLongLong(Long a, Long b) {
        return new BasicLongValue(a % b);
    }

    @Override
    protected RightValue operateOnDoubleLong(Double a, Long b) {
        return new BasicDoubleValue(a % (double)b.longValue());
    }

    @Override
    protected RightValue operateOnLongDouble(Long a, Double b) {
        return new BasicDoubleValue((double)a.longValue() % b);
    }

    @Override
    protected String operatorName() {
        return "Modulo";
    }
}

