/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.utils;

import com.securenative.config.SecureNativeOptions;
import com.securenative.utils.IPUtils;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    public static final String SECURENATIVE_COOKIE = "_sn";
    public static final String SECURENATIVE_HEADER = "x-securenative";
    private static final List<String> ipHeaders = Arrays.asList("x-forwarded-for", "x-client-ip", "x-real-ip", "x-forwarded", "x-cluster-client-ip", "forwarded-for", "forwarded", "via");
    private static final List<String> piiHeaders = Arrays.asList("authorization", "access_token", "apikey", "password", "passwd", "secret", "api_key");

    public static Map<String, String> getHeadersFromRequest(HttpServletRequest request, SecureNativeOptions options) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (options != null && options.getPiiHeaders().size() > 0) {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (options.getPiiHeaders().contains(headerName.toLowerCase()) || options.getPiiHeaders().contains(headerName.toUpperCase())) continue;
                String headerValue = request.getHeader(headerName);
                headersMap.put(headerName, headerValue);
            }
        } else if (options != null && options.getPiiRegexPattern() != null) {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Pattern pattern = Pattern.compile(options.getPiiRegexPattern(), 2);
                Matcher matcher = pattern.matcher(headerName);
                if (matcher.find()) continue;
                String headerValue = request.getHeader(headerName);
                headersMap.put(headerName, headerValue);
            }
        } else {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (piiHeaders.contains(headerName.toLowerCase()) || piiHeaders.contains(headerName.toUpperCase())) continue;
                String headerValue = request.getHeader(headerName);
                headersMap.put(headerName, headerValue);
            }
        }
        return headersMap;
    }

    public static String getSecureHeaderFromRequest(Map<String, String> headers) {
        return headers.getOrDefault(SECURENATIVE_HEADER, "");
    }

    public static String getCookieValueFromRequest(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static String getClientIpFromRequest(HttpServletRequest request, Map<String, String> headers, SecureNativeOptions options) {
        if (options != null && options.getProxyHeaders().size() > 0) {
            for (String header : options.getProxyHeaders()) {
                String headerValue;
                Optional<String> ip;
                if (!headers.containsKey(header) || !(ip = Arrays.stream((headerValue = headers.get(header)).split(",")).map(String::trim).filter(IPUtils::isIpAddress).filter(IPUtils::isValidPublicIp).findFirst()).isPresent()) continue;
                return ip.get();
            }
        }
        Optional<String> bestCandidate = Optional.empty();
        for (String ipHeader : ipHeaders) {
            if (!headers.containsKey(ipHeader)) continue;
            String headerValue = headers.get(ipHeader);
            Optional<String> candidateIp = Arrays.stream(headerValue.split(",")).map(String::trim).filter(IPUtils::isIpAddress).filter(IPUtils::isValidPublicIp).findFirst();
            if (candidateIp.isPresent()) {
                return candidateIp.get();
            }
            if (bestCandidate.isPresent()) continue;
            bestCandidate = Arrays.stream(headerValue.split(",")).map(String::trim).filter(IPUtils::isLoopBack).findFirst();
        }
        return bestCandidate.orElseGet(() -> ((HttpServletRequest)request).getRemoteAddr());
    }

    public static String getRemoteIpFromRequest(HttpServletRequest request) {
        return request.getRemoteAddr();
    }
}

