/*
 * Decompiled with CFR 0.152.
 */
package org.docopt;

import java.util.List;
import org.docopt.Pattern;
import org.docopt.Python;

abstract class LeafPattern
extends Pattern {
    private final String name;
    private Object value;

    public LeafPattern(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public LeafPattern(String name) {
        this(name, null);
    }

    public String toString() {
        return String.format("%s(%s, %s)", this.getClass().getSimpleName(), Python.repr(this.name), Python.repr(this.value));
    }

    @Override
    protected final List<Pattern> flat(Class<?> ... types) {
        if (!Python.bool(types) || Python.in(this.getClass(), types)) {
            return Python.list(this);
        }
        return Python.list();
    }

    @Override
    protected Pattern.MatchResult match(List<LeafPattern> left, List<LeafPattern> collected) {
        if (collected == null) {
            collected = Python.list();
        }
        SingleMatchResult m = this.singleMatch(left);
        Integer pos = m.getPosition();
        LeafPattern match = m.getMatch();
        if (match == null) {
            return new Pattern.MatchResult(false, left, collected);
        }
        List<LeafPattern> left_ = Python.list();
        left_.addAll(left.subList(0, pos));
        if (pos + 1 < left.size()) {
            left_.addAll(left.subList(pos + 1, left.size()));
        }
        List sameName = Python.list();
        for (LeafPattern a : collected) {
            if (!this.name.equals(a.getName())) continue;
            sameName.add(a);
        }
        if (this.value instanceof Integer || this.value instanceof List) {
            Object increment;
            if (this.value instanceof Integer) {
                increment = 1;
            } else {
                List<Object> v = match.getValue();
                Object object = increment = v instanceof String ? Python.list(v) : v;
            }
            if (sameName.isEmpty()) {
                match.setValue(increment);
                return new Pattern.MatchResult(true, left_, Python.plus(collected, Python.list(match)));
            }
            LeafPattern p = (LeafPattern)sameName.get(0);
            Object v = p.getValue();
            if (v instanceof Integer) {
                Integer a = (Integer)v;
                Integer b = (Integer)increment;
                p.setValue(a + b);
            } else if (v instanceof List) {
                List a = (List)v;
                List b = (List)increment;
                a.addAll(b);
            }
            return new Pattern.MatchResult(true, left_, collected);
        }
        return new Pattern.MatchResult(true, left_, Python.plus(collected, Python.list(match)));
    }

    protected abstract SingleMatchResult singleMatch(List<LeafPattern> var1);

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeafPattern other = (LeafPattern)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    static class SingleMatchResult {
        private final Integer position;
        private final LeafPattern match;

        public SingleMatchResult(Integer position, LeafPattern match) {
            this.position = position;
            this.match = match;
        }

        public Integer getPosition() {
            return this.position;
        }

        public LeafPattern getMatch() {
            return this.match;
        }

        public String toString() {
            return String.format("%s(%d, %s)", this.getClass().getSimpleName(), this.position, this.match);
        }
    }
}

