/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.mock;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import okhttp3.Request;
import okio.Timeout;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public final class Calls {
    public static <T> Call<T> defer(Callable<Call<T>> callable) {
        return new DeferredCall<T>(callable);
    }

    public static <T> Call<T> response(@Nullable T successValue) {
        return new FakeCall<T>(Response.success(successValue), null);
    }

    public static <T> Call<T> response(Response<T> response) {
        return new FakeCall<T>(response, null);
    }

    public static <T> Call<T> failure(IOException failure) {
        return new FakeCall(null, failure);
    }

    public static <T> Call<T> failure(Throwable failure) {
        return new FakeCall(null, failure);
    }

    private Calls() {
        throw new AssertionError((Object)"No instances.");
    }

    static final class DeferredCall<T>
    implements Call<T> {
        private final Callable<Call<T>> callable;
        @Nullable
        private Call<T> delegate;

        DeferredCall(Callable<Call<T>> callable) {
            this.callable = callable;
        }

        private synchronized Call<T> getDelegate() {
            Call<T> delegate = this.delegate;
            if (delegate == null) {
                try {
                    delegate = this.callable.call();
                }
                catch (Exception e) {
                    delegate = Calls.failure(e);
                }
                this.delegate = delegate;
            }
            return delegate;
        }

        @Override
        public Response<T> execute() throws IOException {
            return this.getDelegate().execute();
        }

        @Override
        public void enqueue(Callback<T> callback) {
            this.getDelegate().enqueue(callback);
        }

        @Override
        public boolean isExecuted() {
            return this.getDelegate().isExecuted();
        }

        @Override
        public void cancel() {
            this.getDelegate().cancel();
        }

        @Override
        public boolean isCanceled() {
            return this.getDelegate().isCanceled();
        }

        @Override
        public Call<T> clone() {
            return new DeferredCall<T>(this.callable);
        }

        @Override
        public Request request() {
            return this.getDelegate().request();
        }

        @Override
        public Timeout timeout() {
            return this.getDelegate().timeout();
        }
    }

    static final class FakeCall<T>
    implements Call<T> {
        private final Response<T> response;
        private final Throwable error;
        private final AtomicBoolean canceled = new AtomicBoolean();
        private final AtomicBoolean executed = new AtomicBoolean();

        FakeCall(@Nullable Response<T> response, @Nullable Throwable error) {
            if (response == null == (error == null)) {
                throw new AssertionError((Object)"Only one of response or error can be set.");
            }
            this.response = response;
            this.error = error;
        }

        @Override
        public Response<T> execute() throws IOException {
            if (!this.executed.compareAndSet(false, true)) {
                throw new IllegalStateException("Already executed");
            }
            if (this.canceled.get()) {
                throw new IOException("canceled");
            }
            if (this.response != null) {
                return this.response;
            }
            throw (Error)FakeCall.sneakyThrow(this.error);
        }

        private static <T extends Throwable> T sneakyThrow(Throwable t) throws T {
            throw t;
        }

        @Override
        public void enqueue(Callback<T> callback) {
            if (callback == null) {
                throw new NullPointerException("callback == null");
            }
            if (!this.executed.compareAndSet(false, true)) {
                throw new IllegalStateException("Already executed");
            }
            if (this.canceled.get()) {
                callback.onFailure(this, new IOException("canceled"));
            } else if (this.response != null) {
                callback.onResponse(this, this.response);
            } else {
                callback.onFailure(this, this.error);
            }
        }

        @Override
        public boolean isExecuted() {
            return this.executed.get();
        }

        @Override
        public void cancel() {
            this.canceled.set(true);
        }

        @Override
        public boolean isCanceled() {
            return this.canceled.get();
        }

        @Override
        public Call<T> clone() {
            return new FakeCall<T>(this.response, this.error);
        }

        @Override
        public Request request() {
            if (this.response != null) {
                return this.response.raw().request();
            }
            return new Request.Builder().url("http://localhost").build();
        }

        @Override
        public Timeout timeout() {
            return Timeout.NONE;
        }
    }
}

