/*
 * Decompiled with CFR 0.152.
 */
package org.docopt;

import java.util.Arrays;
import java.util.List;
import org.docopt.Argument;
import org.docopt.BranchPattern;
import org.docopt.Command;
import org.docopt.Either;
import org.docopt.LeafPattern;
import org.docopt.OneOrMore;
import org.docopt.Option;
import org.docopt.Optional;
import org.docopt.OptionsShortcut;
import org.docopt.Python;
import org.docopt.Required;

abstract class Pattern {
    private static final List<Class<? extends BranchPattern>> PARENTS = Arrays.asList(Required.class, Optional.class, OptionsShortcut.class, Either.class, OneOrMore.class);

    Pattern() {
    }

    private static Either transform(Pattern pattern) {
        List<List> result = Python.list();
        List groups2 = Python.list();
        groups2.add(Python.list(pattern));
        while (!groups2.isEmpty()) {
            List children = (List)groups2.remove(0);
            Object child = null;
            for (Pattern c : children) {
                if (!PARENTS.contains(c.getClass())) continue;
                child = (BranchPattern)c;
                break;
            }
            if (child != null) {
                List<List<Pattern>> group;
                children.remove(child);
                if (child.getClass() == Either.class) {
                    for (Pattern c : ((BranchPattern)child).getChildren()) {
                        List<Pattern> group2 = Python.list(c);
                        group2.addAll(children);
                        groups2.add(group2);
                    }
                    continue;
                }
                if (child.getClass() == OneOrMore.class) {
                    group = Python.list(((BranchPattern)child).getChildren());
                    group.addAll(((BranchPattern)child).getChildren());
                    group.addAll(children);
                    groups2.add(group);
                    continue;
                }
                group = Python.list(((BranchPattern)child).getChildren());
                group.addAll(children);
                groups2.add(group);
                continue;
            }
            result.add(children);
        }
        List required = Python.list();
        for (List e : result) {
            required.add(new Required(e));
        }
        return new Either(required);
    }

    public Pattern fix() {
        this.fixIdentities(null);
        this.fixRepeatingArguments();
        return this;
    }

    private void fixIdentities(List<Pattern> uniq) {
        if (!(this instanceof BranchPattern)) {
            return;
        }
        if (uniq == null) {
            uniq = Python.list(Python.set(this.flat(new Class[0])));
        }
        List<Pattern> children = ((BranchPattern)this).getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Pattern child = children.get(i);
            if (!(child instanceof BranchPattern)) {
                assert (uniq.contains(child));
                children.set(i, (Pattern)uniq.get(uniq.indexOf(child)));
                continue;
            }
            child.fixIdentities(uniq);
        }
    }

    private void fixRepeatingArguments() {
        List<List> either = Python.list();
        for (Pattern child : Pattern.transform(this).getChildren()) {
            either.add(Python.list(((Required)child).getChildren()));
        }
        for (List $case : either) {
            for (Pattern child : $case) {
                if (Python.count($case, child) <= 1) continue;
                LeafPattern e = (LeafPattern)child;
                if (e.getClass() == Argument.class || e.getClass() == Option.class && ((Option)e).getArgCount() != 0) {
                    if (e.getValue() == null) {
                        e.setValue(Python.list());
                    } else if (!(e.getValue() instanceof List)) {
                        e.setValue(Python.split(e.getValue().toString()));
                    }
                }
                if (e.getClass() != Command.class && (e.getClass() != Option.class || ((Option)e).getArgCount() != 0)) continue;
                e.setValue(0);
            }
        }
    }

    protected abstract List<Pattern> flat(Class<?> ... var1);

    protected abstract MatchResult match(List<LeafPattern> var1, List<LeafPattern> var2);

    protected MatchResult match(List<LeafPattern> left) {
        return this.match(left, null);
    }

    public abstract boolean equals(Object var1);

    static class MatchResult {
        private final boolean match;
        private final List<LeafPattern> left;
        private final List<LeafPattern> collected;

        public MatchResult(boolean match, List<LeafPattern> left, List<LeafPattern> collected) {
            this.match = match;
            this.left = left;
            this.collected = collected;
        }

        public boolean matched() {
            return this.match;
        }

        public List<LeafPattern> getLeft() {
            return this.left;
        }

        public List<LeafPattern> getCollected() {
            return this.collected;
        }
    }
}

