/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary;

import com.simiacryptus.util.binary.BitOutputStream;
import com.simiacryptus.util.binary.Bits;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream {
    private boolean useChecks = false;
    private InputStream inner;
    private Bits remainder = new Bits(0L);

    public static BitInputStream toBitStream(byte[] data) {
        return new BitInputStream(new ByteArrayInputStream(data));
    }

    public BitInputStream(InputStream inner) {
        this.inner = inner;
    }

    public void close() throws IOException {
        this.inner.close();
    }

    public void expect(Bits bits) throws IOException {
        Bits checkBits = this.read(bits.bitLength);
        if (!bits.equals(checkBits)) {
            throw new IOException(String.format("Check failed: %s != %s", checkBits, bits));
        }
    }

    public void expect(double expectedValue) throws IOException {
        Bits checkBits = this.read(64);
        double checkValue = Double.longBitsToDouble(checkBits.toLong());
        if (checkValue != expectedValue) {
            Bits expectedBits = new Bits(Double.doubleToLongBits(expectedValue), 64);
            throw new IOException(String.format("Check for %s failed: %s != %s", expectedValue, checkBits, expectedBits));
        }
    }

    public <T extends Enum<T>> void expect(Enum<T> expect) throws IOException {
        Bits checkBits = this.read(8);
        long expectedLong = expect.ordinal();
        if (checkBits.toLong() != expectedLong) {
            Bits expectedBits = new Bits(expectedLong, 8);
            throw new IOException(String.format("Check for %s failed: %s != %s", expect, checkBits, expectedBits));
        }
    }

    public void expect(int expect) throws IOException {
        Bits checkBits = this.read(32);
        long expectedValue = expect;
        if (checkBits.toLong() != expectedValue) {
            Bits expectedBits = new Bits(expectedValue, 32);
            throw new IOException(String.format("Check for %s failed: %s != %s", expect, checkBits, expectedBits));
        }
    }

    public boolean isUseChecks() {
        return this.useChecks;
    }

    public Bits read(int length) throws IOException {
        int additionalBitsNeeded = length - this.remainder.bitLength;
        int additionalBytesNeeded = (int)Math.ceil((double)additionalBitsNeeded / 8.0);
        this.readAhead(additionalBytesNeeded);
        Bits readBits = this.remainder.range(0, length);
        this.remainder = this.remainder.range(length);
        return readBits;
    }

    public Bits readAhead() throws IOException {
        return this.readAhead(1);
    }

    public Bits readAhead(int bytes) throws IOException {
        if (0 < bytes) {
            Bits newR;
            byte[] buffer = new byte[bytes];
            this.inner.read(buffer);
            this.remainder = newR = this.remainder.concatenate(new Bits(buffer));
        }
        return this.remainder;
    }

    public boolean readBool() throws IOException {
        return Bits.ONE.equals(this.read(1));
    }

    public long readBoundedLong(long max) throws IOException {
        int bits;
        int n = bits = 1L >= max ? 0 : (int)Math.ceil(Math.log(max) / Math.log(2.0));
        if (this.useChecks) {
            this.expect(new Bits(bits, 8));
        }
        return 0 < bits ? this.read(bits).toLong() : 0L;
    }

    public long readVarLong() throws IOException {
        int type = (int)this.read(2).toLong();
        return this.read(BitOutputStream.varLongDepths[type]).toLong();
    }

    public BitInputStream setUseChecks(boolean useChecks) {
        this.useChecks = useChecks;
        return this;
    }
}

