/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary;

import java.util.Arrays;
import java.util.Random;

public class Bits
implements Comparable<Bits> {
    public final int bitLength;
    private final byte[] bytes;
    public static Bits ONE = new Bits(1L, 1);
    public static Bits ZERO = new Bits(0L, 1);
    public static Bits NULL = new Bits(0L, 0);

    public static int dataCompare(Bits left, Bits right) {
        for (int i = 0; i < left.bytes.length; ++i) {
            if (right.bytes.length <= i) {
                return 1;
            }
            int a = left.bytes[i] & 0xFF;
            int b = right.bytes[i] & 0xFF;
            if (a < b) {
                return -1;
            }
            if (a <= b) continue;
            return 1;
        }
        if (left.bitLength < right.bitLength) {
            return -1;
        }
        if (left.bitLength > right.bitLength) {
            return 1;
        }
        return 0;
    }

    public static byte highestOneBit(long v) {
        long h = Long.highestOneBit(v);
        if (0L == v) {
            return 0;
        }
        for (int i = 0; i < 64; i = (int)((byte)(i + 1))) {
            if (h != 1L << i) continue;
            return (byte)(i + 1);
        }
        throw new RuntimeException();
    }

    public static byte[] padLeftBytes(byte[] src, int bytes) {
        byte[] dst = new byte[bytes];
        for (int i = 1; i <= src.length; ++i) {
            dst[dst.length - i] = src[src.length - i];
        }
        return dst;
    }

    public static byte[] shiftLeft(byte[] src, int bits) {
        byte[] dst = new byte[src.length];
        Bits.shiftLeft(src, bits, dst);
        return dst;
    }

    public static void shiftLeft(byte[] src, int bits, byte[] dst) {
        int bitPart = bits % 8;
        int bytePart = bits / 8;
        for (int i = 0; i < dst.length; ++i) {
            int b;
            int a = i + bytePart;
            if (a >= 0 && src.length > a) {
                int n = i;
                dst[n] = (byte)(dst[n] | (byte)((src[a] & 0xFF) << bitPart & 0xFF));
            }
            if ((b = i + bytePart + 1) < 0 || src.length <= b) continue;
            int n = i;
            dst[n] = (byte)(dst[n] | (byte)((src[b] & 0xFF) >> 8 - bitPart & 0xFF));
        }
    }

    public static byte[] shiftRight(byte[] src, int bits) {
        byte[] dst = new byte[src.length];
        Bits.shiftRight(src, bits, dst);
        return dst;
    }

    private static void shiftRight(byte[] src, int bits, byte[] dst) {
        int bitPart = bits % 8;
        int bytePart = bits / 8;
        for (int i = 0; i < dst.length; ++i) {
            int b;
            int a = i - bytePart;
            if (a >= 0 && src.length > a) {
                int n = i;
                dst[n] = (byte)(dst[n] | (byte)((src[a] & 0xFF) >> bitPart & 0xFF));
            }
            if ((b = i - bytePart - 1) < 0 || src.length <= b) continue;
            int n = i;
            dst[n] = (byte)(dst[n] | (byte)((src[b] & 0xFF) << 8 - bitPart & 0xFF));
        }
    }

    public static byte[] toBytes(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data & 0xFFL)};
    }

    public static byte[] trim(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 0) continue;
            return Arrays.copyOfRange(bytes, i, bytes.length);
        }
        return new byte[0];
    }

    public Bits(byte ... data) {
        this(data, data.length * 8);
    }

    private Bits(byte[] data, int length) {
        if (0 > length) {
            throw new IllegalArgumentException();
        }
        if (data.length * 8 < length) {
            throw new IllegalArgumentException();
        }
        if (length < (data.length - 1) * 8) {
            throw new IllegalArgumentException();
        }
        this.bitLength = length;
        this.bytes = Bits.shiftLeft(data, (data.length * 8 - length) % 8);
    }

    public Bits(long data) {
        this(data, (int)Bits.highestOneBit(data));
    }

    public Bits(long value, int length) {
        int rightShift;
        if (0 > length) {
            throw new IllegalArgumentException();
        }
        byte highestOneBit = Bits.highestOneBit(value);
        if (highestOneBit > length) {
            throw new IllegalArgumentException();
        }
        this.bitLength = length;
        this.bytes = new byte[(int)Math.ceil((double)length / 8.0)];
        byte[] data = Bits.toBytes(value);
        int leftShift = ((data = Bits.trim(data)).length * 8 - highestOneBit) % 8;
        if (leftShift > (rightShift = length - highestOneBit)) {
            Bits.shiftLeft(data, leftShift - rightShift, this.bytes);
        } else {
            Bits.shiftRight(data, rightShift - leftShift, this.bytes);
        }
        assert (value == this.toLong());
    }

    public Bits(Random random, int length) {
        this.bitLength = length;
        this.bytes = new byte[(int)Math.ceil((double)length / 8.0)];
        random.nextBytes(this.bytes);
        int excessBits = this.bytes.length * 8 - this.bitLength;
        int n = this.bytes.length - 1;
        this.bytes[n] = (byte)(this.bytes[n] & 255 << excessBits);
    }

    public Bits bitwiseAnd(Bits right) {
        int i;
        int lengthDifference = this.bitLength - right.bitLength;
        if (lengthDifference < 0) {
            return this.concatenate(new Bits(0L, -lengthDifference)).bitwiseAnd(right);
        }
        if (lengthDifference > 0) {
            return this.bitwiseAnd(right.concatenate(new Bits(0L, lengthDifference)));
        }
        Bits returnValue = new Bits(new byte[this.bytes.length], this.bitLength);
        for (i = 0; i < this.bytes.length; ++i) {
            returnValue.bytes[i] = this.bytes[i];
        }
        for (i = 0; i < right.bytes.length; ++i) {
            int n = i;
            returnValue.bytes[n] = (byte)(returnValue.bytes[n] & right.bytes[i]);
        }
        return returnValue;
    }

    public Bits bitwiseOr(Bits right) {
        int i;
        int lengthDifference = this.bitLength - right.bitLength;
        if (lengthDifference < 0) {
            return this.concatenate(new Bits(0L, -lengthDifference)).bitwiseOr(right);
        }
        if (lengthDifference > 0) {
            return this.bitwiseOr(right.concatenate(new Bits(0L, lengthDifference)));
        }
        Bits returnValue = new Bits(new byte[this.bytes.length], this.bitLength);
        for (i = 0; i < this.bytes.length; ++i) {
            returnValue.bytes[i] = this.bytes[i];
        }
        for (i = 0; i < right.bytes.length; ++i) {
            int n = i;
            returnValue.bytes[n] = (byte)(returnValue.bytes[n] | right.bytes[i]);
        }
        return returnValue;
    }

    public Bits bitwiseXor(Bits right) {
        int i;
        int lengthDifference = this.bitLength - right.bitLength;
        if (lengthDifference < 0) {
            return this.concatenate(new Bits(0L, -lengthDifference)).bitwiseXor(right);
        }
        if (lengthDifference > 0) {
            return this.bitwiseXor(right.concatenate(new Bits(0L, lengthDifference)));
        }
        Bits returnValue = new Bits(new byte[this.bytes.length], this.bitLength);
        for (i = 0; i < this.bytes.length; ++i) {
            returnValue.bytes[i] = this.bytes[i];
        }
        for (i = 0; i < right.bytes.length; ++i) {
            int n = i;
            returnValue.bytes[n] = (byte)(returnValue.bytes[n] ^ right.bytes[i]);
        }
        return returnValue;
    }

    @Override
    public int compareTo(Bits arg0) {
        return Bits.dataCompare(this, arg0);
    }

    public Bits concatenate(Bits right) {
        int newBitLength = this.bitLength + right.bitLength;
        int newByteLength = (int)Math.ceil((double)newBitLength / 8.0);
        Bits result = new Bits(new byte[newByteLength], newBitLength);
        Bits.shiftLeft(this.bytes, 0, result.bytes);
        Bits.shiftRight(right.bytes, this.bitLength, result.bytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bits other = (Bits)obj;
        if (!Arrays.equals(this.bytes, other.bytes)) {
            return false;
        }
        return this.bitLength == other.bitLength;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + this.bitLength;
        return result;
    }

    public Bits leftShift(int bits) {
        return this.concatenate(new Bits(0L, bits));
    }

    public Bits next() {
        if (!this.toBitString().contains("0")) {
            return null;
        }
        return new Bits(this.toLong() + 1L, this.bitLength);
    }

    public Bits range(int i) {
        return this.range(i, this.bitLength - i);
    }

    public Bits range(int start, int length) {
        if (0 == length) {
            return new Bits(0L);
        }
        if (start < 0) {
            throw new IllegalArgumentException();
        }
        if (start + length > this.bitLength) {
            throw new IllegalArgumentException();
        }
        Bits returnValue = new Bits(new byte[(int)Math.ceil((double)length / 8.0)], length);
        Bits.shiftLeft(this.bytes, start, returnValue.bytes);
        int bitsInLastByte = length % 8;
        if (0 == bitsInLastByte) {
            bitsInLastByte = 8;
        }
        int n = returnValue.bytes.length - 1;
        returnValue.bytes[n] = (byte)(returnValue.bytes[n] & 255 << 8 - bitsInLastByte);
        return returnValue;
    }

    public boolean startsWith(Bits key) {
        if (key.bitLength > this.bitLength) {
            return false;
        }
        Bits prefix = key.bitLength < this.bitLength ? this.range(0, key.bitLength) : this;
        return prefix.compareTo(key) == 0;
    }

    public String toBitString() {
        byte[] shiftRight;
        StringBuffer sb = new StringBuffer();
        int shift = this.bytes.length * 8 - this.bitLength;
        for (byte b : shiftRight = Bits.shiftRight(this.bytes, shift)) {
            String asString = Integer.toBinaryString(b & 0xFF);
            while (asString.length() < 8) {
                asString = "0" + asString;
            }
            sb.append(asString);
        }
        if (sb.length() >= this.bitLength) {
            return sb.substring(sb.length() - this.bitLength, sb.length());
        }
        String n = sb.toString();
        sb = new StringBuffer();
        while (sb.length() + n.length() < this.bitLength) {
            sb.append("0");
        }
        return sb.toString() + n;
    }

    public String toHexString() {
        StringBuffer sb = new StringBuffer();
        for (byte b : this.bytes) {
            sb.append(Integer.toHexString(b & 0xFF));
        }
        return sb.substring(0, this.bitLength / 4);
    }

    public long toLong() {
        long value = 0L;
        for (byte b : Bits.shiftRight(this.bytes, this.bytes.length * 8 - this.bitLength)) {
            long shifted;
            value = shifted = value << 8;
            int asInt = b & 0xFF;
            value += (long)asInt;
        }
        return value;
    }

    public String toString() {
        return this.toBitString();
    }
}

