/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.data.SerialArrayList;
import com.simiacryptus.util.data.SerialType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class CharTree {
    private static NodeType _NodeType = new NodeType();
    private static CursorType _CursorType = new CursorType();
    private final SerialArrayList<NodeData> nodes = _NodeType.newList(new NodeData('\u0000', -1, -1, -1, 0));
    private final SerialArrayList<CursorData> cursors = _CursorType.newList();
    private final ArrayList<String> documents = new ArrayList();

    public int getMemorySize() {
        return this.cursors.getMemorySize() + this.nodes.getMemorySize();
    }

    public int getIndexedSize() {
        return this.documents.stream().mapToInt(doc -> doc.length()).sum();
    }

    public Node root() {
        return new Node(this.nodes.get(0).setCursorCount(this.cursors.length()), 0, 0, null);
    }

    public Node traverse(String search) {
        char token;
        Optional<Node> child;
        Node cursor = this.root();
        char[] cArray = search.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n && (child = cursor.getChild(token = cArray[i])).isPresent(); ++i) {
            cursor = child.get();
        }
        return cursor;
    }

    public CharTree truncate() {
        this.cursors.clear();
        return this;
    }

    public CharTree index() {
        return this.index(Integer.MAX_VALUE);
    }

    public CharTree index(int maxLevels) {
        return this.index(maxLevels, 1);
    }

    public CharTree index(int maxLevels, int minWeight) {
        this.root().visitFirst(node -> {
            if (node.depth < maxLevels && node.getCursorCount() > minWeight && (node.getToken() != '\u0000' || node.depth == 0)) {
                node.split();
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharTree addDocument(String document) {
        int index;
        if (this.root().getNumberOfChildren() >= 0) {
            throw new IllegalStateException("Tree sorting has begun");
        }
        CharTree charTree = this;
        synchronized (charTree) {
            index = this.documents.size();
            this.documents.add(document);
        }
        this.cursors.addAll(IntStream.range(0, document.length()).mapToObj(i -> new CursorData(index, i)).collect(Collectors.toList()));
        return this;
    }

    private static class CursorType
    implements SerialType<CursorData> {
        private CursorType() {
        }

        @Override
        public int getSize() {
            return 8;
        }

        @Override
        public CursorData read(ByteBuffer input) throws IOException {
            return new CursorData(input.getInt(), input.getInt());
        }

        @Override
        public void write(ByteBuffer output, CursorData value) throws IOException {
            output.putInt(value.documentId);
            output.putInt(value.position);
        }
    }

    private static class CursorData {
        int documentId;
        int position;

        public CursorData(int documentId, int position) {
            this.documentId = documentId;
            this.position = position;
        }

        public CursorData setDocumentId(int documentId) {
            this.documentId = documentId;
            return this;
        }

        public CursorData setPosition(int position) {
            this.position = position;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CursorData that = (CursorData)o;
            if (this.documentId != that.documentId) {
                return false;
            }
            return this.position == that.position;
        }

        public int hashCode() {
            int result = this.documentId;
            result = 31 * result + this.position;
            return result;
        }
    }

    public class Cursor {
        private final CursorData data;
        private final short depth;

        public Cursor(CursorData data, short depth) {
            this.data = data;
            this.depth = depth;
        }

        public String getDocument() {
            return (String)CharTree.this.documents.get(this.data.documentId);
        }

        public boolean hasNext() {
            return this.depth + this.data.position + 1 < this.getDocument().length();
        }

        public char getToken() {
            int index = this.depth + this.data.position;
            String document = this.getDocument();
            return index >= document.length() ? (char)'\u0000' : document.charAt(index);
        }

        public Cursor next() {
            return new Cursor(this.data, (short)(this.depth + 1));
        }

        public int getPosition() {
            return this.data.position + this.depth;
        }
    }

    private static class NodeType
    implements SerialType<NodeData> {
        private NodeType() {
        }

        @Override
        public int getSize() {
            return 16;
        }

        @Override
        public NodeData read(ByteBuffer input) throws IOException {
            return new NodeData(input.getChar(), input.getShort(), input.getInt(), input.getInt(), input.getInt());
        }

        @Override
        public void write(ByteBuffer output, NodeData value) throws IOException {
            output.putChar(value.token);
            output.putShort(value.numberOfChildren);
            output.putInt(value.firstChildIndex);
            output.putInt(value.cursorCount);
            output.putInt(value.firstCursorIndex);
        }
    }

    private static class NodeData {
        char token;
        short numberOfChildren;
        int firstChildIndex;
        int cursorCount;
        int firstCursorIndex;

        public NodeData(char token, short numberOfChildren, int firstChildIndex, int cursorCount, int firstCursorIndex) {
            this.token = token;
            this.numberOfChildren = numberOfChildren;
            this.firstChildIndex = firstChildIndex;
            this.cursorCount = cursorCount;
            this.firstCursorIndex = firstCursorIndex;
        }

        public NodeData setToken(char token) {
            this.token = token;
            return this;
        }

        public NodeData setNumberOfChildren(short numberOfChildren) {
            this.numberOfChildren = numberOfChildren;
            return this;
        }

        public NodeData setFirstChildIndex(int firstChildIndex) {
            this.firstChildIndex = firstChildIndex;
            return this;
        }

        public NodeData setCursorCount(int cursorCount) {
            this.cursorCount = cursorCount;
            return this;
        }

        public NodeData setFirstCursorIndex(int firstCursorIndex) {
            this.firstCursorIndex = firstCursorIndex;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeData nodeData = (NodeData)o;
            if (this.token != nodeData.token) {
                return false;
            }
            if (this.numberOfChildren != nodeData.numberOfChildren) {
                return false;
            }
            if (this.firstChildIndex != nodeData.firstChildIndex) {
                return false;
            }
            if (this.cursorCount != nodeData.cursorCount) {
                return false;
            }
            return this.firstCursorIndex == nodeData.firstCursorIndex;
        }

        public int hashCode() {
            int result = this.token;
            result = 31 * result + this.numberOfChildren;
            result = 31 * result + this.firstChildIndex;
            result = 31 * result + this.cursorCount;
            result = 31 * result + this.firstCursorIndex;
            return result;
        }
    }

    public class Node {
        private final NodeData data;
        public final short depth;
        private final int index;
        public final Node parent;

        public Node(NodeData data, short depth, int index, Node parent) {
            this.data = data;
            this.depth = depth;
            this.index = index;
            this.parent = parent;
        }

        public Node refresh() {
            return new Node((NodeData)CharTree.this.nodes.get(this.index), this.depth, this.index, this.parent);
        }

        public String getString() {
            return (null == this.parent ? "" : this.parent.getString()) + (0 == this.depth ? "" : Character.valueOf(this.data.token));
        }

        public char getToken() {
            return this.data.token;
        }

        public short getNumberOfChildren() {
            return this.data.numberOfChildren;
        }

        public short getDepth() {
            return this.depth;
        }

        public int getCursorCount() {
            return this.data.cursorCount;
        }

        public Node visitFirst(Consumer<Node> visitor) {
            visitor.accept(this);
            Node refresh = this.refresh();
            refresh.getChildren().forEach(n -> n.visitFirst(visitor));
            return refresh;
        }

        public Node visitLast(Consumer<Node> visitor) {
            this.getChildren().forEach(n -> n.visitLast(visitor));
            visitor.accept(this);
            return this.refresh();
        }

        public Stream<Node> getChildren() {
            if (this.data.firstChildIndex >= 0) {
                return IntStream.range(0, this.data.numberOfChildren).mapToObj(i -> {
                    int childIndex = this.data.firstChildIndex + i;
                    NodeData child = (NodeData)CharTree.this.nodes.get(childIndex);
                    return new Node(child, (short)(this.depth + 1), childIndex, this);
                });
            }
            return Stream.empty();
        }

        public Optional<Node> getChild(char token) {
            return this.getChildren().filter(x -> x.getToken() == token).findFirst();
        }

        public Map<String, List<Cursor>> getCursorsByDocument() {
            return this.getCursors().collect(Collectors.groupingBy(x -> x.getDocument()));
        }

        public Stream<Cursor> getCursors() {
            return IntStream.range(0, this.data.cursorCount).mapToObj(i -> new Cursor((CursorData)CharTree.this.cursors.get(i + this.data.firstCursorIndex), this.depth));
        }

        public Node split() {
            if (this.data.firstChildIndex < 0) {
                Map<Character, SerialArrayList> sortedChildren = ((Stream)this.getCursors().parallel()).collect(Collectors.groupingBy(y -> Character.valueOf(y.next().getToken()), Collectors.reducing(new SerialArrayList<CursorData>((SerialType<CursorData>)_CursorType, 0), cursor -> new SerialArrayList<CursorData>(_CursorType, ((Cursor)cursor).data), (left, right) -> left.add(right))));
                int cursorWriteIndex = this.data.firstCursorIndex;
                ArrayList<NodeData> childNodes = new ArrayList<NodeData>(sortedChildren.size());
                for (Map.Entry<Character, SerialArrayList> e : sortedChildren.entrySet()) {
                    int length = e.getValue().length();
                    CharTree.this.cursors.putAll(e.getValue(), cursorWriteIndex);
                    childNodes.add(new NodeData(e.getKey().charValue(), -1, -1, length, cursorWriteIndex));
                    cursorWriteIndex += length;
                }
                return new Node(CharTree.this.nodes.update(this.index, data -> data.setFirstChildIndex(CharTree.this.nodes.addAll(childNodes)).setNumberOfChildren((short)childNodes.size())), this.depth, this.index, this.parent);
            }
            return this;
        }
    }
}

