/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.codes;

import com.simiacryptus.util.binary.BitInputStream;
import com.simiacryptus.util.binary.BitOutputStream;
import java.io.IOException;

public class Gaussian {
    public final double mean;
    public final double stdDev;
    public static final double LOG2 = Math.log(2.0);

    public static Gaussian fromBinomial(double probability, long totalPopulation) {
        if (0.0 >= (double)totalPopulation) {
            throw new IllegalArgumentException();
        }
        if (0.0 >= probability) {
            throw new IllegalArgumentException();
        }
        if (1.0 <= probability) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(probability)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(probability)) {
            throw new IllegalArgumentException();
        }
        return new Gaussian(probability * (double)totalPopulation, Math.sqrt((double)totalPopulation * probability * (1.0 - probability)));
    }

    public static double log2(double d) {
        return Math.log(d) / LOG2;
    }

    public Gaussian(double mean, double stdDev) {
        if (Double.isNaN(mean)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(mean)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(stdDev)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(stdDev)) {
            throw new IllegalArgumentException();
        }
        if (0.0 >= stdDev) {
            throw new IllegalArgumentException();
        }
        this.mean = mean;
        this.stdDev = stdDev;
    }

    public long decode(BitInputStream in, long max) throws IOException {
        long centralWindow;
        if (0L == max) {
            return 0L;
        }
        int bits = (int)(Math.round(Gaussian.log2(2.0 * this.stdDev)) - 1L);
        if (0 > bits) {
            bits = 0;
        }
        if ((double)(centralWindow = 1L << bits) >= (double)(max + 1L) / 2.0) {
            return in.readBoundedLong(max + 1L);
        }
        long stdDevWindowStart = (long)(this.mean - (double)(centralWindow / 2L));
        long stdDevWindowEnd = stdDevWindowStart + centralWindow;
        if (stdDevWindowStart < 0L) {
            stdDevWindowEnd += -stdDevWindowStart;
            stdDevWindowStart += -stdDevWindowStart;
        } else {
            long delta = stdDevWindowEnd - (max + 1L);
            if (delta > 0L) {
                stdDevWindowStart -= delta;
                stdDevWindowEnd -= delta;
            }
        }
        if (in.readBool()) {
            return in.readBoundedLong(centralWindow) + stdDevWindowStart;
        }
        boolean side = stdDevWindowStart <= 0L ? true : (stdDevWindowEnd > max ? false : in.readBool());
        if (side) {
            return stdDevWindowEnd + in.readBoundedLong(1L + max - stdDevWindowEnd);
        }
        return in.readBoundedLong(stdDevWindowStart);
    }

    public void encode(BitOutputStream out, long value, long max) throws IOException {
        long centralWindow;
        if (0L == max) {
            return;
        }
        int bits = (int)(Math.round(Gaussian.log2(2.0 * this.stdDev)) - 1L);
        if (0 > bits) {
            bits = 0;
        }
        if ((double)(centralWindow = 1L << bits) >= (double)(max + 1L) / 2.0) {
            out.writeBoundedLong(value, max + 1L);
            return;
        }
        long stdDevWindowStart = (long)(this.mean - (double)(centralWindow / 2L));
        long stdDevWindowEnd = stdDevWindowStart + centralWindow;
        if (stdDevWindowStart < 0L) {
            stdDevWindowEnd += -stdDevWindowStart;
            stdDevWindowStart += -stdDevWindowStart;
        } else {
            long delta = stdDevWindowEnd - (max + 1L);
            if (delta > 0L) {
                stdDevWindowStart -= delta;
                stdDevWindowEnd -= delta;
            }
        }
        if (value < stdDevWindowStart) {
            out.write(false);
            if (stdDevWindowEnd <= max) {
                out.write(false);
            }
            out.writeBoundedLong(value, stdDevWindowStart);
        } else if (value < stdDevWindowEnd) {
            out.write(true);
            out.writeBoundedLong(value - stdDevWindowStart, centralWindow);
        } else {
            out.write(false);
            if (stdDevWindowStart > 0L) {
                out.write(true);
            }
            out.writeBoundedLong(value - stdDevWindowEnd, 1L + max - stdDevWindowEnd);
        }
    }
}

