/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.data;

import com.simiacryptus.util.data.SerialType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public class SerialArrayList<U> {
    private final SerialType<U> factory;
    public final int unitSize;
    private byte[] buffer;
    private int maxByte = 0;

    public SerialArrayList(SerialType<U> factory, SerialArrayList<U> ... items) {
        this.factory = factory;
        this.unitSize = factory.getSize();
        this.maxByte = Arrays.stream(items).mapToInt(item -> item.maxByte).sum();
        this.buffer = new byte[this.maxByte];
        int cursor = 0;
        for (int i = 0; i < items.length; ++i) {
            SerialArrayList<U> item2 = items[i];
            System.arraycopy(item2.buffer, 0, this.buffer, cursor, item2.maxByte);
            cursor += item2.maxByte;
        }
    }

    public SerialArrayList(SerialType<U> factory, Collection<U> items) {
        this.factory = factory;
        this.unitSize = factory.getSize();
        this.buffer = new byte[items.size() * this.unitSize];
        int i = 0;
        for (U x : items) {
            this.set(i++, x);
        }
    }

    public SerialArrayList(SerialType<U> factory, U ... items) {
        this.factory = factory;
        this.unitSize = factory.getSize();
        this.buffer = new byte[items.length * this.unitSize];
        for (int i = 0; i < items.length; ++i) {
            this.set(i, items[i]);
        }
    }

    public SerialArrayList(SerialType<U> factory) {
        this.factory = factory;
        this.unitSize = factory.getSize();
        this.buffer = new byte[1024];
    }

    public SerialArrayList(SerialType<U> factory, int size) {
        this.factory = factory;
        this.unitSize = factory.getSize();
        this.buffer = new byte[this.unitSize * size];
    }

    public SerialArrayList<U> add(SerialArrayList<U> right) {
        return new SerialArrayList<U>(this.factory, this, right);
    }

    public synchronized void clear() {
        this.buffer = new byte[0];
        this.maxByte = 0;
    }

    public int length() {
        return this.maxByte / this.unitSize;
    }

    public U get(int i) {
        ByteBuffer view = this.getView(i);
        try {
            return this.factory.read(view);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized int add(U value) {
        int length = this.length();
        this.set(length, value);
        return length;
    }

    public synchronized U update(int i, Function<U, U> updater) {
        U updated = updater.apply(this.get(i));
        this.set(i, updated);
        return updated;
    }

    public void set(int i, U value) {
        this.ensureCapacity((i + 1) * this.unitSize);
        ByteBuffer view = this.getView(i);
        try {
            this.factory.write(view, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ByteBuffer getView(int i) {
        ByteBuffer duplicate = ByteBuffer.wrap(this.buffer);
        duplicate.position(this.unitSize * i);
        return duplicate;
    }

    private synchronized void ensureCapacity(int bytes) {
        if (this.maxByte < bytes) {
            this.maxByte = bytes;
        }
        int targetBytes = this.buffer.length;
        while (targetBytes < bytes) {
            targetBytes = Math.max(targetBytes * 2, 1);
        }
        if (targetBytes > this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, targetBytes);
        }
    }

    public synchronized int addAll(Collection<U> data) {
        int startIndex = this.length();
        this.putAll(data, startIndex);
        return startIndex;
    }

    public synchronized void putAll(Collection<U> data, int startIndex) {
        this.putAll(new SerialArrayList<U>(this.factory, data), startIndex);
    }

    public synchronized void putAll(SerialArrayList<U> data, int startIndex) {
        this.ensureCapacity(startIndex * this.unitSize + data.maxByte);
        System.arraycopy(data.buffer, 0, this.buffer, startIndex * this.unitSize, data.maxByte);
    }

    public int getMemorySize() {
        return this.buffer.length;
    }

    public SerialArrayList<U> copy() {
        return new SerialArrayList<U>(this.factory, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerialArrayList that = (SerialArrayList)o;
        if (this.unitSize != that.unitSize) {
            return false;
        }
        if (this.maxByte != that.maxByte) {
            return false;
        }
        if (!this.factory.equals(that.factory)) {
            return false;
        }
        return Arrays.equals(this.buffer, that.buffer);
    }

    public int hashCode() {
        int result = this.factory.hashCode();
        result = 31 * result + this.unitSize;
        result = 31 * result + Arrays.hashCode(this.buffer);
        result = 31 * result + this.maxByte;
        return result;
    }
}

