/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.test;

import com.simiacryptus.util.test.AsyncListIterator;
import com.simiacryptus.util.test.Spool;
import com.simiacryptus.util.test.TestDocument;
import com.simiacryptus.util.test.WikiArticle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class TweetSentiment
extends TestDocument {
    public static String url = "http://thinknook.com/wp-content/uploads/2012/09/Sentiment-Analysis-Dataset.zip";
    public static String file = "Sentiment-Analysis-Dataset.zip";
    private static final ArrayList<TweetSentiment> queue = new ArrayList();
    private static volatile Thread thread;
    public final int category;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clear() throws InterruptedException {
        if (thread == null) return;
        Class<WikiArticle> clazz = WikiArticle.class;
        synchronized (WikiArticle.class) {
            if (thread == null) return;
            thread.interrupt();
            thread.join();
            thread = null;
            queue.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Stream<TweetSentiment> load() {
        if (thread == null) {
            Class<WikiArticle> clazz = WikiArticle.class;
            // MONITORENTER : com.simiacryptus.util.test.WikiArticle.class
            if (thread == null) {
                thread = new Thread(TweetSentiment::read);
                thread.setDaemon(true);
                thread.start();
            }
            // MONITOREXIT : clazz
        }
        AsyncListIterator<TweetSentiment> iterator = new AsyncListIterator<TweetSentiment>(queue, thread);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1), false).filter(x -> x != null);
    }

    private static void read() {
        try {
            InputStream load = Spool.load(url, file);
            try (ZipInputStream in = new ZipInputStream(load);){
                ZipEntry entry = in.getNextEntry();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    String read;
                    String[] header = reader.readLine().split(",");
                    while (null != (read = reader.readLine())) {
                        String[] values = read.split(",");
                        queue.add(new TweetSentiment(values[3].trim(), Integer.parseInt(values[1].trim())));
                    }
                }
            }
        }
        catch (IOException load) {
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof InterruptedException)) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TweetSentiment(String text, int category) {
        super(text, text);
        this.category = category;
    }
}

