/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.data.SerialArrayList;
import com.simiacryptus.util.text.CharTrie;
import com.simiacryptus.util.text.CursorData;
import com.simiacryptus.util.text.CursorType;
import com.simiacryptus.util.text.IndexNode;
import com.simiacryptus.util.text.NodeData;
import com.simiacryptus.util.text.NodeType;
import com.simiacryptus.util.text.TrieNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CharTrieIndex
extends CharTrie {
    protected final SerialArrayList<CursorData> cursors;
    protected final ArrayList<String> documents;

    private CharTrieIndex(SerialArrayList<NodeData> nodes, SerialArrayList<CursorData> cursors, ArrayList<String> documents) {
        super(nodes);
        this.cursors = cursors;
        this.documents = documents;
    }

    public CharTrieIndex(CharTrieIndex copyFrom) {
        this(copyFrom.nodes.copy(), copyFrom.cursors.copy(), new ArrayList<String>(copyFrom.documents));
    }

    public CharTrieIndex() {
        this(new SerialArrayList<NodeData>(NodeType.INSTANCE, new NodeData('\u0000', -1, -1, -1L, 0L)), new SerialArrayList<CursorData>(CursorType.INSTANCE), new ArrayList<String>());
    }

    @Override
    public int getMemorySize() {
        return this.cursors.getMemorySize() + this.nodes.getMemorySize();
    }

    @Override
    public long getIndexedSize() {
        return this.documents.isEmpty() ? super.getIndexedSize() : (long)this.documents.stream().mapToInt(doc -> doc.length()).sum();
    }

    @Override
    public CharTrie truncate() {
        return new CharTrie(this);
    }

    public CharTrieIndex index() {
        return this.index(Integer.MAX_VALUE);
    }

    public CharTrieIndex index(int maxLevels) {
        return this.index(maxLevels, 0);
    }

    public CharTrieIndex index(int maxLevels, int minWeight) {
        AtomicInteger numberSplit = new AtomicInteger(0);
        int depth = -1;
        do {
            numberSplit.set(0);
            if (0 == ++depth) {
                numberSplit.incrementAndGet();
                this.root().split();
                continue;
            }
            this.root().streamDecendents(depth).forEach(node -> {
                TrieNode godparent = node.godparent();
                if (!(node.getDepth() >= maxLevels || null != godparent && godparent.getCursorCount() <= (long)minWeight || node.getChar() == '\u0000' && node.getDepth() != 0)) {
                    ((IndexNode)node).split();
                    numberSplit.incrementAndGet();
                }
            });
        } while (numberSplit.get() > 0);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDictionary(String document) {
        int index;
        if (this.root().getNumberOfChildren() >= 0) {
            throw new IllegalStateException("Tree sorting has begun");
        }
        CharTrieIndex charTrieIndex = this;
        synchronized (charTrieIndex) {
            index = this.documents.size();
            this.documents.add(document);
        }
        this.cursors.addAll(IntStream.range(0, 1).mapToObj(i -> new CursorData(index, i)).collect(Collectors.toList()));
        this.nodes.update(0, node -> node.setCursorCount(this.cursors.length()));
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDocument(String document) {
        int index;
        if (this.root().getNumberOfChildren() >= 0) {
            throw new IllegalStateException("Tree sorting has begun");
        }
        CharTrieIndex charTrieIndex = this;
        synchronized (charTrieIndex) {
            index = this.documents.size();
            this.documents.add(document);
        }
        this.cursors.addAll(IntStream.range(0, document.length() + 1).mapToObj(i -> new CursorData(index, i)).collect(Collectors.toList()));
        this.nodes.update(0, node -> node.setCursorCount(this.cursors.length()));
        return index;
    }

    public CharTrie addAlphabet(String document) {
        document.chars().mapToObj(i -> new String(Character.toChars(i))).forEach(s -> this.addDocument((String)s));
        return this;
    }

    @Override
    CharTrieIndex recomputeCursorDetails() {
        return (CharTrieIndex)super.recomputeCursorDetails();
    }

    @Override
    public CharTrieIndex copy() {
        return new CharTrieIndex(this);
    }

    @Override
    public IndexNode root() {
        return new IndexNode(this, 0, 0, null);
    }

    @Override
    public IndexNode traverse(String search) {
        return this.root().traverse(search);
    }

    public static CharTrie indexWords(Collection<String> documents, int maxLevels, int minWeight) {
        return CharTrieIndex.create(documents, maxLevels, minWeight, true);
    }

    public static CharTrie indexFulltext(Collection<String> documents, int maxLevels, int minWeight) {
        return CharTrieIndex.create(documents, maxLevels, minWeight, false);
    }

    private static CharTrie create(Collection<String> documents, int maxLevels, int minWeight, boolean words) {
        ArrayList a = new ArrayList();
        ArrayList<String> b = new ArrayList<String>();
        int blockSize = 0x100000;
        for (String s : documents) {
            b.add(s);
            if (b.stream().mapToInt(x -> x.length()).sum() <= blockSize) continue;
            a.add(b);
            b = new ArrayList();
        }
        a.add(b);
        return a.parallelStream().map(list -> {
            CharTrieIndex trie = new CharTrieIndex();
            list.forEach(s -> {
                if (words) {
                    trie.addDictionary((String)s);
                } else {
                    trie.addDocument((String)s);
                }
            });
            trie.index(maxLevels, minWeight);
            return trie;
        }).reduce((l, r) -> l.add((CharTrie)r)).get();
    }
}

