/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.data.SerialArrayList;
import com.simiacryptus.util.data.SerialType;
import com.simiacryptus.util.text.CharTrie;
import com.simiacryptus.util.text.CharTrieIndex;
import com.simiacryptus.util.text.Cursor;
import com.simiacryptus.util.text.CursorData;
import com.simiacryptus.util.text.CursorType;
import com.simiacryptus.util.text.NodeData;
import com.simiacryptus.util.text.TrieNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class IndexNode
extends TrieNode {
    public IndexNode(CharTrie trie, short depth, int index, TrieNode parent) {
        super(trie, index, parent);
    }

    public IndexNode(CharTrie trie, int index) {
        super(trie, index);
    }

    public Map<String, List<Cursor>> getCursorsByDocument() {
        return this.getCursors().collect(Collectors.groupingBy(x -> x.getDocument()));
    }

    public Stream<Cursor> getCursors() {
        return LongStream.range(0L, this.getData().cursorCount).mapToObj(i -> new Cursor((CharTrieIndex)this.trie, ((CharTrieIndex)this.trie).cursors.get((int)(i + this.getData().firstCursorIndex)), this.getDepth()));
    }

    public TrieNode split() {
        if (this.getData().firstChildIndex < 0) {
            TreeMap<Character, SerialArrayList> sortedChildren = new TreeMap<Character, SerialArrayList>(((Stream)this.getCursors().parallel()).collect(Collectors.groupingBy(y -> Character.valueOf(y.next().getToken()), Collectors.reducing(new SerialArrayList<CursorData>((SerialType<CursorData>)CursorType.INSTANCE, 0), cursor -> new SerialArrayList<CursorData>(CursorType.INSTANCE, cursor.data), (left, right) -> left.add(right)))));
            long cursorWriteIndex = this.getData().firstCursorIndex;
            ArrayList<NodeData> childNodes = new ArrayList<NodeData>(sortedChildren.size());
            for (Map.Entry<Character, SerialArrayList> e : sortedChildren.entrySet()) {
                int length = e.getValue().length();
                ((CharTrieIndex)this.trie).cursors.putAll(e.getValue(), (int)cursorWriteIndex);
                childNodes.add(new NodeData(e.getKey().charValue(), -1, -1, length, cursorWriteIndex));
                cursorWriteIndex += (long)length;
            }
            int firstChildIndex = this.trie.nodes.addAll(childNodes);
            short size = (short)childNodes.size();
            this.trie.ensureParentIndexCapacity(firstChildIndex, size, this.index);
            this.trie.nodes.update(this.index, data -> data.setFirstChildIndex(firstChildIndex).setNumberOfChildren(size));
            return new IndexNode(this.trie, this.getDepth(), this.index, this.getParent());
        }
        return this;
    }

    @Override
    protected TrieNode newNode(int index) {
        return new IndexNode(this.trie, index);
    }

    @Override
    public IndexNode godparent() {
        return (IndexNode)super.godparent();
    }

    @Override
    public IndexNode refresh() {
        return (IndexNode)super.refresh();
    }

    public IndexNode visitFirstIndex(Consumer<? super IndexNode> visitor) {
        visitor.accept(this);
        IndexNode refresh = this.refresh();
        refresh.getChildren().forEach(n -> n.visitFirstIndex(visitor));
        return refresh;
    }

    public IndexNode visitLastIndex(Consumer<? super IndexNode> visitor) {
        this.getChildren().forEach(n -> n.visitLastIndex(visitor));
        visitor.accept(this);
        return this.refresh();
    }

    public Stream<? extends IndexNode> getChildren() {
        if (this.getData().firstChildIndex >= 0) {
            return IntStream.range(0, this.getData().numberOfChildren).mapToObj(i -> new IndexNode(this.trie, (short)(this.getDepth() + 1), this.getData().firstChildIndex + i, this));
        }
        return Stream.empty();
    }

    public Optional<? extends IndexNode> getChild(char token) {
        NodeData data = this.getData();
        int min = data.firstChildIndex;
        int max = data.firstChildIndex + data.numberOfChildren - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            IndexNode node = new IndexNode(this.trie, (short)(this.getDepth() + 1), i, this);
            char c = node.getChar();
            int compare = Character.compare(c, token);
            if (c < token) {
                min = i + 1;
                continue;
            }
            if (c > token) {
                max = i - 1;
                continue;
            }
            return Optional.of(node);
        }
        return Optional.empty();
    }

    @Override
    public IndexNode traverse(String str) {
        return (IndexNode)super.traverse(str);
    }

    @Override
    public IndexNode traverse(long cursorId) {
        return (IndexNode)super.traverse(cursorId);
    }
}

