/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.util.test.BinaryChunkIterator;
import com.simiacryptus.util.test.LabeledObject;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class Util {
    private static final AtomicInteger idcounter = new AtomicInteger(0);
    private static final String jvmId = UUID.randomUUID().toString();
    public static final ThreadLocal<Random> R = new ThreadLocal<Random>(){
        public final Random r = new Random(System.nanoTime());

        @Override
        protected Random initialValue() {
            return new Random(this.r.nextLong());
        }
    };

    public static void add(DoubleSupplier f, double[] data) {
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] + f.getAsDouble();
        }
    }

    public static Stream<byte[]> binaryStream(String path, String name, int skip, int recordSize) throws IOException {
        File file = new File(path, name);
        byte[] fileData = IOUtils.toByteArray((InputStream)new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)))));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(fileData));
        in.skip(skip);
        return Util.toIterator(new BinaryChunkIterator(in, recordSize));
    }

    public static String[] currentStack() {
        return (String[])Stream.of(Thread.currentThread().getStackTrace()).map(Object::toString).toArray(String[]::new);
    }

    public static byte[] read(DataInputStream i, int s) throws IOException {
        int read;
        byte[] b = new byte[s];
        for (int pos = 0; b.length > pos; pos += read) {
            read = i.read(b, pos, b.length - pos);
            if (0 != read) continue;
            throw new RuntimeException();
        }
        return b;
    }

    public static void report(Stream<String> fragments) throws FileNotFoundException, IOException {
        File outDir = new File("reports");
        outDir.mkdirs();
        StackTraceElement caller = Util.getLast(Arrays.stream(Thread.currentThread().getStackTrace()).filter(x -> x.getClassName().contains("simiacryptus")));
        File report = new File(outDir, caller.getClassName() + "_" + caller.getLineNumber() + ".html");
        PrintStream out = new PrintStream(new FileOutputStream(report));
        out.println("<html><head></head><body>");
        fragments.forEach(out::println);
        out.println("</body></html>");
        out.close();
        Desktop.getDesktop().browse(report.toURI());
    }

    public static <T> T getLast(Stream<T> stream) {
        List collect = stream.collect(Collectors.toList());
        Object last = collect.get(collect.size() - 1);
        return last;
    }

    public static void report(String ... fragments) throws FileNotFoundException, IOException {
        Util.report(Stream.of(fragments));
    }

    public static String toInlineImage(BufferedImage img, String alt) {
        return Util.toInlineImage(new LabeledObject<BufferedImage>(img, alt));
    }

    public static String toInlineImage(LabeledObject<BufferedImage> img) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img.data, "PNG", (OutputStream)b);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] byteArray = b.toByteArray();
        String encode = Base64.getEncoder().encodeToString(byteArray);
        return "<img src=\"data:image/png;base64," + encode + "\" alt=\"" + img.label + "\" />";
    }

    public static <T> Stream<T> toIterator(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliterator(iterator, 1L, 16), false);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        return Util.toStream(iterator, 0);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator, int size) {
        return Util.toStream(iterator, size, false);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator, int size, boolean parallel) {
        return StreamSupport.stream(Spliterators.spliterator(iterator, (long)size, 16), parallel);
    }

    public static UUID uuid() {
        String index = Integer.toHexString(idcounter.incrementAndGet());
        while (index.length() < 8) {
            index = "0" + index;
        }
        String tempId = jvmId.substring(0, jvmId.length() - index.length()) + index;
        return UUID.fromString(tempId);
    }

    public static TemporalUnit cvt(TimeUnit units) {
        switch (units) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
        }
        throw new IllegalArgumentException(units.toString());
    }
}

