/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary;

import com.simiacryptus.util.binary.BitOutputStream;
import com.simiacryptus.util.binary.Bits;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class BitInputStream {
    private InputStream inner;
    private Bits remainder = new Bits(0L);

    public static BitInputStream toBitStream(byte[] data) {
        return new BitInputStream(new ByteArrayInputStream(data));
    }

    public BitInputStream(InputStream inner) {
        this.inner = inner;
    }

    public void close() throws IOException {
        this.inner.close();
    }

    public int availible() throws IOException {
        return this.remainder.bitLength + 8 * this.inner.available();
    }

    public <T extends Enum<T>> void expect(Enum<T> expect) throws IOException {
        Bits checkBits = this.read(8);
        long expectedLong = expect.ordinal();
        if (checkBits.toLong() != expectedLong) {
            Bits expectedBits = new Bits(expectedLong, 8);
            throw new IOException(String.format("Check for %s failed: %s != %s", expect, checkBits, expectedBits));
        }
    }

    public void expect(Bits bits) throws IOException {
        int size = Math.min(this.availible(), bits.bitLength);
        Bits read = this.read(size);
        if (!bits.range(0, size).equals(read)) {
            throw new RuntimeException(String.format("%s is not expected %s", read, bits));
        }
    }

    public Bits read(int bits) throws IOException {
        int additionalBitsNeeded = bits - this.remainder.bitLength;
        int additionalBytesNeeded = (int)Math.ceil((double)additionalBitsNeeded / 8.0);
        if (additionalBytesNeeded > 0) {
            this.readAhead(additionalBytesNeeded);
        }
        Bits readBits = this.remainder.range(0, bits);
        this.remainder = this.remainder.range(bits);
        return readBits;
    }

    public Bits peek(int bits) throws IOException {
        int additionalBitsNeeded = bits - this.remainder.bitLength;
        int additionalBytesNeeded = (int)Math.ceil((double)additionalBitsNeeded / 8.0);
        if (additionalBytesNeeded > 0) {
            this.readAhead(additionalBytesNeeded);
        }
        return this.remainder.range(0, Math.min(bits, this.remainder.bitLength));
    }

    public Bits readAhead() throws IOException {
        return this.readAhead(1);
    }

    public Bits readAhead(int bytes) throws IOException {
        byte[] buffer;
        int bytesRead;
        assert (0 < bytes);
        if (0 < bytes && (bytesRead = this.inner.read(buffer = new byte[bytes])) > 0) {
            this.remainder = this.remainder.concatenate(new Bits(Arrays.copyOf(buffer, bytesRead)));
        }
        return this.remainder;
    }

    public boolean readBool() throws IOException {
        return Bits.ONE.equals(this.read(1));
    }

    public long readBoundedLong(long max) throws IOException {
        int bits = 0L >= max ? 0 : (int)(Math.floor(Math.log(max) / Math.log(2.0)) + 1.0);
        return 0 < bits ? this.read(bits).toLong() : 0L;
    }

    public long readVarLong() throws IOException {
        int type = (int)this.read(2).toLong();
        return this.read(BitOutputStream.varLongDepths[type]).toLong();
    }

    public long peekLongCoord(long max) throws IOException {
        if (1L >= max) {
            return 0L;
        }
        int bits = 1 + (int)Math.ceil(Math.log(max) / Math.log(2.0));
        Bits peek = this.peek(bits);
        double divisor = 1 << peek.bitLength;
        long value = (int)((double)peek.toLong() * (double)max / divisor);
        assert (0L <= value);
        assert (max >= value);
        return value;
    }

    public int peekIntCoord(int max) throws IOException {
        if (1 >= max) {
            return 0;
        }
        int bits = 1 + (int)Math.ceil(Math.log(max) / Math.log(2.0));
        Bits peek = this.peek(bits);
        double divisor = 1 << peek.bitLength;
        int value = (int)((double)peek.toLong() * (double)max / divisor);
        assert (0 <= value);
        assert (max >= value);
        return value;
    }

    public short readVarShort() throws IOException {
        return this.readVarShort(7);
    }

    public short readVarShort(int optimal) throws IOException {
        int[] varShortDepths = new int[]{optimal, 16};
        int type = (int)this.read(1).toLong();
        return (short)this.read(varShortDepths[type]).toLong();
    }

    public char readChar() throws IOException {
        return (char)this.read(16).toLong();
    }
}

