/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.bitset;

import com.simiacryptus.util.binary.BitInputStream;
import com.simiacryptus.util.binary.BitOutputStream;
import com.simiacryptus.util.binary.Bits;
import com.simiacryptus.util.collections.CountCollection;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BitsCollection<C extends Map<Bits, AtomicInteger>>
extends CountCollection<Bits, C> {
    public final Integer bitDepth;

    public BitsCollection(C collection) {
        super(collection);
        this.bitDepth = null;
    }

    public BitsCollection(int bitDepth, C collection) {
        super(collection);
        this.bitDepth = bitDepth;
    }

    public CodeType getType(Bits bits) {
        if (null != this.bitDepth) {
            if (bits.bitLength == this.bitDepth) {
                return CodeType.Terminal;
            }
            if (bits.bitLength < this.bitDepth) {
                return CodeType.Prefix;
            }
            throw new IllegalArgumentException();
        }
        return CodeType.Unknown;
    }

    public abstract void read(BitInputStream var1) throws IOException;

    public abstract void write(BitOutputStream var1) throws IOException;

    public static enum CodeType {
        Terminal,
        Prefix,
        Unknown;

    }
}

