/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.lang;

import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

public abstract class ResourcePool<T> {
    private final HashSet<T> all;
    private final LinkedBlockingQueue<T> pool = new LinkedBlockingQueue();
    private final int maxItems;

    public ResourcePool(int maxItems) {
        this.maxItems = maxItems;
        this.all = new HashSet(this.maxItems);
    }

    public abstract T create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void with(Consumer<T> f) {
        T poll = this.pool.poll();
        if (null == poll) {
            HashSet<T> hashSet = this.all;
            synchronized (hashSet) {
                if (this.all.size() < this.maxItems) {
                    poll = this.create();
                    this.all.add(poll);
                }
            }
        }
        if (null == poll) {
            try {
                poll = this.pool.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        f.accept(poll);
        this.pool.add(poll);
    }
}

