/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.test;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class BinaryChunkIterator
implements Iterator<byte[]> {
    private DataInputStream in;
    private int recordSize;

    public BinaryChunkIterator(DataInputStream in, int recordSize) {
        this.in = in;
        this.recordSize = recordSize;
    }

    @Override
    public boolean hasNext() {
        try {
            return 0 < this.in.available();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] next() {
        assert (this.hasNext());
        try {
            return BinaryChunkIterator.read(this.in, this.recordSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] read(DataInputStream i, int s) throws IOException {
        int read;
        byte[] b = new byte[s];
        for (int pos = 0; b.length > pos; pos += read) {
            read = i.read(b, pos, b.length - pos);
            if (0 != read) continue;
            throw new RuntimeException();
        }
        return b;
    }

    public static <T> Stream<T> toIterator(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliterator(iterator, 1L, 16), false);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        return BinaryChunkIterator.toStream(iterator, 0);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator, int size) {
        return BinaryChunkIterator.toStream(iterator, size, false);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator, int size, boolean parallel) {
        return StreamSupport.stream(Spliterators.spliterator(iterator, (long)size, 16), parallel);
    }

    public Stream<byte[]> toStream() {
        return BinaryChunkIterator.toStream(this);
    }
}

