/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

class NodeData {
    char token;
    short numberOfChildren;
    int firstChildIndex;
    long cursorCount;
    long firstCursorIndex;

    public NodeData(char token, short numberOfChildren, int firstChildIndex, long cursorCount, long firstCursorIndex) {
        this.token = token;
        this.numberOfChildren = numberOfChildren;
        this.firstChildIndex = firstChildIndex;
        this.cursorCount = cursorCount;
        this.firstCursorIndex = firstCursorIndex;
    }

    public NodeData setToken(char token) {
        this.token = token;
        return this;
    }

    public NodeData setNumberOfChildren(short numberOfChildren) {
        this.numberOfChildren = numberOfChildren;
        return this;
    }

    public NodeData setFirstChildIndex(int firstChildIndex) {
        this.firstChildIndex = firstChildIndex;
        return this;
    }

    public NodeData setCursorCount(long cursorCount) {
        this.cursorCount = cursorCount;
        return this;
    }

    public NodeData setFirstCursorIndex(long firstCursorIndex) {
        this.firstCursorIndex = firstCursorIndex;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeData nodeData = (NodeData)o;
        if (this.token != nodeData.token) {
            return false;
        }
        if (this.numberOfChildren != nodeData.numberOfChildren) {
            return false;
        }
        if (this.firstChildIndex != nodeData.firstChildIndex) {
            return false;
        }
        if (this.cursorCount != nodeData.cursorCount) {
            return false;
        }
        return this.firstCursorIndex == nodeData.firstCursorIndex;
    }

    public int hashCode() {
        int result = this.token;
        result = 31 * result + this.numberOfChildren;
        result = 31 * result + this.firstChildIndex;
        result = 31 * result + Long.hashCode(this.cursorCount);
        result = 31 * result + Long.hashCode(this.firstCursorIndex);
        return result;
    }
}

